/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.dao;

import com.xiaomi.youpin.docean.anno.Service;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.api.enums.AppTypeEnum;
import org.apache.ozhera.log.manager.model.bo.MachineQueryParam;
import org.apache.ozhera.log.manager.model.pojo.MiLogMachine;
import org.apache.ozhera.log.manager.model.pojo.MilogSpaceDO;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.impl.NutDao;
import org.nutz.dao.impl.sql.NutSql;
import org.nutz.dao.pager.Pager;
import org.nutz.dao.sql.Sql;

@Service
public class MilogMachineDao {
    @Resource
    private NutDao dao;

    public List<MiLogMachine> queryMachineByType(AppTypeEnum appTypeEnum) {
        return this.dao.query(MiLogMachine.class, (Condition)Cnd.where((String)"type", (String)"=", (Object)appTypeEnum.getType()));
    }

    public MiLogMachine insert(MiLogMachine miLogMachine) {
        return (MiLogMachine)this.dao.insert((Object)miLogMachine);
    }

    public void deleteMachineInfo(Long id) {
        this.dao.delete(MiLogMachine.class, id.longValue());
    }

    public List<MiLogMachine> queryMachinePage(MachineQueryParam param) {
        return this.dao.query(MiLogMachine.class, (Condition)this.assembleParam(param).orderBy("utime", "desc"), new Pager(param.getPageNum().intValue(), param.getPageSize().intValue()));
    }

    public Integer queryMachinePageCount(MachineQueryParam param) {
        return this.dao.count(MilogSpaceDO.class, (Condition)this.assembleParam(param));
    }

    private Cnd assembleParam(MachineQueryParam param) {
        Cnd cnd = Cnd.NEW();
        if (null != param.getId()) {
            cnd.where().and("space_name", "=", (Object)param.getId());
        }
        if (null != param.getType()) {
            cnd.where().and("type", "=", (Object)param.getType());
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getIp())) {
            cnd.where().and("ip", "=", (Object)param.getIp());
        }
        return cnd;
    }

    public MiLogMachine queryById(Long id) {
        Cnd cnd = Cnd.where((String)"id", (String)"=", (Object)id);
        List miLogMachines = this.dao.query(MiLogMachine.class, (Condition)cnd);
        if (CollectionUtils.isNotEmpty((Collection)miLogMachines)) {
            return (MiLogMachine)miLogMachines.get(miLogMachines.size() - 1);
        }
        return null;
    }

    public void executeSql(String sql) {
        this.dao.execute((Sql)new NutSql(sql));
    }
}

