/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.xiaomi.youpin.docean.anno.Service;
import com.xiaomi.youpin.docean.plugin.config.anno.Value;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.manager.common.exception.MilogManageException;
import org.apache.ozhera.log.manager.dao.MilogSpaceDao;
import org.apache.ozhera.log.manager.model.Pair;
import org.apache.ozhera.log.manager.model.bo.SpacePartitionBalance;
import org.apache.ozhera.log.manager.model.page.PageInfo;
import org.apache.ozhera.log.manager.model.pojo.MilogSpaceDO;
import org.apache.ozhera.log.manager.model.vo.MachinePartitionParam;
import org.apache.ozhera.log.manager.model.vo.SpaceIpParam;
import org.apache.ozhera.log.manager.service.StreamPartitionService;
import org.apache.ozhera.log.manager.service.extension.common.CommonExtensionServiceFactory;
import org.apache.ozhera.log.manager.service.extension.resource.ResourceExtensionService;
import org.apache.ozhera.log.manager.service.extension.resource.ResourceExtensionServiceFactory;
import org.apache.ozhera.log.manager.service.impl.MilogConfigNacosServiceImpl;
import org.apache.ozhera.log.model.MiLogStreamConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class StreamPartitionServiceImpl
implements StreamPartitionService {
    private static final Logger log = LoggerFactory.getLogger(StreamPartitionServiceImpl.class);
    @Resource
    private MilogConfigNacosServiceImpl logConfigNacosService;
    @Resource
    private MilogSpaceDao logSpaceDao;
    @Value(value="$log_stream_name")
    private String log_stream_name;
    private ResourceExtensionService resourceExtensionService;

    public void init() {
        this.resourceExtensionService = ResourceExtensionServiceFactory.getResourceExtensionService();
    }

    @Override
    public PageInfo<SpacePartitionBalance> querySpacePartitionBalance(MachinePartitionParam partitionParam) {
        MiLogStreamConfig config = this.buildMiLogStreamConfig(partitionParam.getMachineRoom());
        Map<Pair<Long, String>, List<String>> spaceIps = this.buildSpaceIpsMap(config.getConfig());
        List<Long> spaceIds = this.resourceExtensionService.getSpaceIdsByNameExcluded(partitionParam.getSpaceName());
        List<SpacePartitionBalance> spacePartitionBalanceList = this.buildSpacePartitionBalanceList(spaceIps);
        if (CollectionUtils.isNotEmpty(spaceIds)) {
            spacePartitionBalanceList = spacePartitionBalanceList.stream().filter(data -> spaceIds.contains(data.getSpaceId())).collect(Collectors.toList());
        }
        List pageList = CollectionUtil.page((int)(partitionParam.getPageNum() - 1), (int)partitionParam.getPageSize(), spacePartitionBalanceList);
        this.updateSpaceNames(pageList);
        return this.buildPageInfo(partitionParam, spacePartitionBalanceList, pageList);
    }

    private void updateSpaceNames(List<SpacePartitionBalance> spacePartitionBalanceList) {
        spacePartitionBalanceList.forEach(data -> {
            MilogSpaceDO milogSpaceDO = this.logSpaceDao.queryById(data.getSpaceId());
            data.setSpaceName(milogSpaceDO.getSpaceName());
        });
    }

    @Override
    public PageInfo<Pair<Long, String>> queryIpPartitionBalance(MachinePartitionParam partitionParam) {
        MiLogStreamConfig config = this.buildMiLogStreamConfig(partitionParam.getMachineRoom());
        List<Long> excludingMifeSpaceIds = this.resourceExtensionService.getSpaceIdsByNameExcluded(partitionParam.getSpaceName());
        Map spaceKeys = (Map)config.getConfig().get(partitionParam.getUniqueKey());
        List pairList = spaceKeys.entrySet().stream().filter(data -> excludingMifeSpaceIds.contains(data.getKey())).sorted(Map.Entry.comparingByKey()).map(data -> Pair.of((Long)data.getKey(), (String)data.getValue())).collect(Collectors.toList());
        List pageList = CollectionUtil.page((int)(partitionParam.getPageNum() - 1), (int)partitionParam.getPageSize(), pairList);
        pageList = pageList.stream().map(data -> {
            MilogSpaceDO milogSpaceDO = this.logSpaceDao.queryById((Long)data.getKey());
            return Pair.of((Long)data.getKey(), milogSpaceDO.getSpaceName());
        }).collect(Collectors.toList());
        return this.buildPageInfo(partitionParam, pairList, pageList);
    }

    @Override
    public PageInfo<Pair<String, String>> queryStreamList(MachinePartitionParam partitionParam) {
        MiLogStreamConfig config = this.buildMiLogStreamConfig(partitionParam.getMachineRoom());
        List dataList = config.getConfig().keySet().stream().filter(data -> {
            if (StringUtils.isNotEmpty((CharSequence)partitionParam.getUniqueKey())) {
                return Objects.equals(partitionParam.getUniqueKey(), data);
            }
            return true;
        }).map(ip -> Pair.of(ip, this.queryStreamHostname((String)ip))).collect(Collectors.toList());
        return this.buildPageInfo(partitionParam, dataList, dataList);
    }

    private MiLogStreamConfig buildMiLogStreamConfig(String machineRoom) {
        this.logConfigNacosService.chooseCurrentEnvNacosService(machineRoom);
        MiLogStreamConfig config = this.logConfigNacosService.getStreamConfigNacosProvider(machineRoom).getConfig(null);
        if (config == null) {
            throw new MilogManageException("\u5f53\u524d\u673a\u623fnacos\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        return config;
    }

    @Override
    public Boolean addSpaceToIp(SpaceIpParam param) {
        MiLogStreamConfig config = this.buildMiLogStreamConfig(param.getMachineRoom());
        for (String uniqueKey : param.getUniqueKeys()) {
            config.getConfig().putIfAbsent(uniqueKey, new HashMap());
            for (Long spaceId : param.getSpaceIds()) {
                String spaceKey = String.format("%s%s%s", CommonExtensionServiceFactory.getCommonExtensionService().getLogManagePrefix(), "create_tail_config:", spaceId);
                ((Map)config.getConfig().get(uniqueKey)).putIfAbsent(spaceId, spaceKey);
            }
        }
        this.logConfigNacosService.getStreamConfigNacosPublisher(param.getMachineRoom()).publish(param.getSpaceId(), config);
        return true;
    }

    @Override
    public Boolean delSpaceToIp(SpaceIpParam param) {
        MiLogStreamConfig config = this.buildMiLogStreamConfig(param.getMachineRoom());
        Map spaceMap = (Map)config.getConfig().get(param.getUniqueKey());
        if (null != spaceMap) {
            spaceMap.remove(param.getSpaceId());
            if (spaceMap.isEmpty()) {
                config.getConfig().remove(param.getUniqueKey());
            }
            this.logConfigNacosService.getStreamConfigNacosPublisher(param.getMachineRoom()).publish(param.getSpaceId(), config);
        }
        return true;
    }

    @Override
    public boolean streamReBalance() {
        return false;
    }

    @Override
    public String queryStreamHostname(String ip) {
        return this.resourceExtensionService.queryHostName(ip);
    }

    @Override
    public List<Pair<String, Long>> findUnIncludedSpaceList(SpaceIpParam param) {
        MiLogStreamConfig config = this.buildMiLogStreamConfig(param.getMachineRoom());
        Map spaceKeys = (Map)config.getConfig().get(param.getUniqueKey());
        ArrayList includedSpaceList = new ArrayList(spaceKeys.keySet());
        List<MilogSpaceDO> allSpaces = this.logSpaceDao.queryByName(param.getSpaceName());
        List pairList = allSpaces.parallelStream().filter(space -> !includedSpaceList.contains(space.getId())).map(space -> Pair.of(space.getSpaceName(), space.getId())).collect(Collectors.toList());
        return CollectionUtil.page((int)(param.getPageNum() - 1), (int)param.getPageSize(), pairList);
    }

    @Override
    public List<Pair<String, String>> queryAllUniqueKeyList(SpaceIpParam param) {
        MiLogStreamConfig config = this.buildMiLogStreamConfig(param.getMachineRoom());
        return config.getConfig().entrySet().stream().filter(data -> !((Map)data.getValue()).containsKey(param.getSpaceId())).map(data -> Pair.of((String)data.getKey(), (String)data.getKey())).collect(Collectors.toList());
    }

    private Map<Pair<Long, String>, List<String>> buildSpaceIpsMap(Map<String, Map<Long, String>> configConfig) {
        HashMap<Pair<Long, String>, List<String>> spaceIps = new HashMap<Pair<Long, String>, List<String>>();
        for (Map.Entry<String, Map<Long, String>> ipEntry : configConfig.entrySet()) {
            for (Map.Entry<Long, String> spaceEntry : ipEntry.getValue().entrySet()) {
                Pair<Long, String> spacePair = new Pair<Long, String>(spaceEntry.getKey(), spaceEntry.getValue());
                spaceIps.computeIfAbsent(spacePair, k -> new ArrayList()).add(ipEntry.getKey());
            }
        }
        return spaceIps;
    }

    private List<SpacePartitionBalance> buildSpacePartitionBalanceList(Map<Pair<Long, String>, List<String>> spaceIps) {
        List<SpacePartitionBalance> balanceList = spaceIps.entrySet().stream().map(entry -> {
            SpacePartitionBalance spacePartitionBalance = new SpacePartitionBalance();
            Pair spacePair = (Pair)entry.getKey();
            spacePartitionBalance.setSpaceId((Long)spacePair.getKey());
            spacePartitionBalance.setSpaceIdentifiers((String)spacePair.getValue());
            spacePartitionBalance.setMachineUniques((List)entry.getValue());
            return spacePartitionBalance;
        }).sorted(Comparator.comparing(SpacePartitionBalance::getSpaceId)).collect(Collectors.toList());
        return balanceList;
    }
}

