/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.nacos;

import com.alibaba.nacos.api.config.ConfigFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import com.xiaomi.data.push.nacos.NacosNaming;
import com.xiaomi.youpin.docean.anno.Component;
import com.xiaomi.youpin.docean.plugin.config.anno.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.manager.common.MilogConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class MultipleNacosConfig {
    private static final Logger log = LoggerFactory.getLogger(MultipleNacosConfig.class);
    @Value(value="$nacosAddr")
    private String nacosAdders;
    private static Map<String, ConfigService> nacosServiceMap = new HashMap<String, ConfigService>();
    private static Map<String, NacosNaming> nacosNamingMap = new HashMap<String, NacosNaming>();

    public void init() {
        Arrays.stream(StringUtils.split((String)this.nacosAdders, (String)"\\$")).forEach(address -> {
            try {
                nacosServiceMap.put((String)address, ConfigFactory.createConfigService((String)address));
                nacosNamingMap.put((String)address, MilogConfig.buildNacosNaming(address));
            }
            catch (NacosException e) {
                log.error(String.format("multiple nacos address init error:address:%s", address), (Throwable)e);
            }
        });
        log.info("multiple nacos service address:{}", nacosServiceMap);
        log.info("multiple nacos naming address:{}", nacosNamingMap);
    }

    public static List<String> getAllNachosAdders() {
        return new ArrayList<String>(nacosServiceMap.keySet());
    }

    public static ConfigService getConfigService(String nacosAddress) {
        return nacosServiceMap.get(nacosAddress);
    }

    public static NacosNaming getNacosNaming(String nacosAddress) {
        return nacosNamingMap.get(nacosAddress);
    }
}

