/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class OidcConfigurationMetadata {
    public static final String ISSUER = "issuer";
    public static final String TOKEN_ENDPOINT = "token_endpoint";
    public static final String INTROSPECTION_ENDPOINT = "introspection_endpoint";
    public static final String AUTHORIZATION_ENDPOINT = "authorization_endpoint";
    public static final String JWKS_ENDPOINT = "jwks_uri";
    public static final String USERINFO_ENDPOINT = "userinfo_endpoint";
    public static final String END_SESSION_ENDPOINT = "end_session_endpoint";
    private static final String REGISTRATION_ENDPOINT = "registration_endpoint";
    private static final String REVOCATION_ENDPOINT = "revocation_endpoint";
    public static final String SCOPES_SUPPORTED = "scopes_supported";
    private final String discoveryUri;
    private final String tokenUri;
    private final String introspectionUri;
    private final String authorizationUri;
    private final String jsonWebKeySetUri;
    private final String userInfoUri;
    private final String endSessionUri;
    private final String registrationUri;
    private final String revocationUri;
    private final String issuer;
    private final JsonObject json;

    public OidcConfigurationMetadata(String tokenUri, String introspectionUri, String authorizationUri, String jsonWebKeySetUri, String userInfoUri, String endSessionUri, String registrationUri, String revocationUri, String issuer) {
        this.discoveryUri = null;
        this.tokenUri = tokenUri;
        this.introspectionUri = introspectionUri;
        this.authorizationUri = authorizationUri;
        this.jsonWebKeySetUri = jsonWebKeySetUri;
        this.userInfoUri = userInfoUri;
        this.endSessionUri = endSessionUri;
        this.registrationUri = registrationUri;
        this.revocationUri = revocationUri;
        this.issuer = issuer;
        this.json = null;
    }

    public OidcConfigurationMetadata(JsonObject wellKnownConfig) {
        this(wellKnownConfig, null, null);
    }

    public OidcConfigurationMetadata(JsonObject wellKnownConfig, OidcConfigurationMetadata localMetadataConfig, String discoveryUri) {
        this.discoveryUri = discoveryUri;
        this.tokenUri = OidcConfigurationMetadata.getMetadataValue(wellKnownConfig, TOKEN_ENDPOINT, localMetadataConfig == null ? null : localMetadataConfig.tokenUri);
        this.introspectionUri = OidcConfigurationMetadata.getMetadataValue(wellKnownConfig, INTROSPECTION_ENDPOINT, localMetadataConfig == null ? null : localMetadataConfig.introspectionUri);
        this.authorizationUri = OidcConfigurationMetadata.getMetadataValue(wellKnownConfig, AUTHORIZATION_ENDPOINT, localMetadataConfig == null ? null : localMetadataConfig.authorizationUri);
        this.jsonWebKeySetUri = OidcConfigurationMetadata.getMetadataValue(wellKnownConfig, JWKS_ENDPOINT, localMetadataConfig == null ? null : localMetadataConfig.jsonWebKeySetUri);
        this.userInfoUri = OidcConfigurationMetadata.getMetadataValue(wellKnownConfig, USERINFO_ENDPOINT, localMetadataConfig == null ? null : localMetadataConfig.userInfoUri);
        this.endSessionUri = OidcConfigurationMetadata.getMetadataValue(wellKnownConfig, END_SESSION_ENDPOINT, localMetadataConfig == null ? null : localMetadataConfig.endSessionUri);
        this.registrationUri = OidcConfigurationMetadata.getMetadataValue(wellKnownConfig, REGISTRATION_ENDPOINT, localMetadataConfig == null ? null : localMetadataConfig.registrationUri);
        this.revocationUri = OidcConfigurationMetadata.getMetadataValue(wellKnownConfig, REVOCATION_ENDPOINT, localMetadataConfig == null ? null : localMetadataConfig.revocationUri);
        this.issuer = OidcConfigurationMetadata.getMetadataValue(wellKnownConfig, ISSUER, localMetadataConfig == null ? null : localMetadataConfig.issuer);
        this.json = wellKnownConfig;
    }

    private static String getMetadataValue(JsonObject wellKnownConfig, String propertyName, String localValue) {
        return localValue != null ? localValue : wellKnownConfig.getString(propertyName);
    }

    public String getDiscoveryUri() {
        return this.discoveryUri;
    }

    public String getTokenUri() {
        return this.tokenUri;
    }

    public String getRevocationUri() {
        return this.revocationUri;
    }

    public String getIntrospectionUri() {
        return this.introspectionUri;
    }

    public String getAuthorizationUri() {
        return this.authorizationUri;
    }

    public String getJsonWebKeySetUri() {
        return this.jsonWebKeySetUri;
    }

    public String getUserInfoUri() {
        return this.userInfoUri;
    }

    public String getEndSessionUri() {
        return this.endSessionUri;
    }

    public String getRegistrationUri() {
        return this.registrationUri;
    }

    public List<String> getSupportedScopes() {
        return this.getStringList(SCOPES_SUPPORTED);
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String get(String propertyName) {
        return this.json == null ? null : this.json.getString(propertyName);
    }

    public List<String> getStringList(String propertyName) {
        JsonArray array;
        JsonArray jsonArray = array = this.json == null ? null : this.json.getJsonArray(propertyName);
        if (array != null) {
            List values = array.getList();
            return Collections.unmodifiableList(values);
        }
        return null;
    }

    public boolean contains(String propertyName) {
        return this.json == null ? false : this.json.containsKey(propertyName);
    }

    public Set<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.json.fieldNames());
    }
}

