/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.storage;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.polaris.core.storage.AccessConfig;
import org.immutables.value.Generated;

@Generated(from="AccessConfig", generator="Immutables")
public final class ImmutableAccessConfig
implements AccessConfig {
    private final ImmutableMap<String, String> credentials;
    private final ImmutableMap<String, String> extraProperties;
    private final ImmutableMap<String, String> internalProperties;
    private final Instant expiresAt;
    private transient int hashCode;

    private ImmutableAccessConfig(ImmutableMap<String, String> credentials, ImmutableMap<String, String> extraProperties, ImmutableMap<String, String> internalProperties, Instant expiresAt) {
        this.credentials = credentials;
        this.extraProperties = extraProperties;
        this.internalProperties = internalProperties;
        this.expiresAt = expiresAt;
    }

    public ImmutableMap<String, String> credentials() {
        return this.credentials;
    }

    public ImmutableMap<String, String> extraProperties() {
        return this.extraProperties;
    }

    public ImmutableMap<String, String> internalProperties() {
        return this.internalProperties;
    }

    @Override
    public Optional<Instant> expiresAt() {
        return Optional.ofNullable(this.expiresAt);
    }

    public final ImmutableAccessConfig withCredentials(Map<String, ? extends String> entries) {
        if (this.credentials == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableAccessConfig((ImmutableMap<String, String>)newValue, this.extraProperties, this.internalProperties, this.expiresAt);
    }

    public final ImmutableAccessConfig withExtraProperties(Map<String, ? extends String> entries) {
        if (this.extraProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableAccessConfig(this.credentials, (ImmutableMap<String, String>)newValue, this.internalProperties, this.expiresAt);
    }

    public final ImmutableAccessConfig withInternalProperties(Map<String, ? extends String> entries) {
        if (this.internalProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableAccessConfig(this.credentials, this.extraProperties, (ImmutableMap<String, String>)newValue, this.expiresAt);
    }

    public final ImmutableAccessConfig withExpiresAt(Instant value) {
        Instant newValue = Objects.requireNonNull(value, "expiresAt");
        if (this.expiresAt == newValue) {
            return this;
        }
        return new ImmutableAccessConfig(this.credentials, this.extraProperties, this.internalProperties, newValue);
    }

    public final ImmutableAccessConfig withExpiresAt(Optional<? extends Instant> optional) {
        Instant value = optional.orElse(null);
        if (this.expiresAt == value) {
            return this;
        }
        return new ImmutableAccessConfig(this.credentials, this.extraProperties, this.internalProperties, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAccessConfig && this.equalsByValue((ImmutableAccessConfig)another);
    }

    private boolean equalsByValue(ImmutableAccessConfig another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.credentials.equals(another.credentials) && this.extraProperties.equals(another.extraProperties) && this.internalProperties.equals(another.internalProperties) && Objects.equals(this.expiresAt, another.expiresAt);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.credentials.hashCode();
        h += (h << 5) + this.extraProperties.hashCode();
        h += (h << 5) + this.internalProperties.hashCode();
        h += (h << 5) + Objects.hashCode(this.expiresAt);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AccessConfig").omitNullValues().add("credentials", this.credentials).add("extraProperties", this.extraProperties).add("internalProperties", this.internalProperties).add("expiresAt", (Object)this.expiresAt).toString();
    }

    public static ImmutableAccessConfig copyOf(AccessConfig instance) {
        if (instance instanceof ImmutableAccessConfig) {
            return (ImmutableAccessConfig)instance;
        }
        return ImmutableAccessConfig.builder().from(instance).build();
    }

    public Builder toBuilder() {
        return ImmutableAccessConfig.builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AccessConfig", generator="Immutables")
    public static final class Builder
    implements AccessConfig.Builder {
        private ImmutableMap.Builder<String, String> credentials = ImmutableMap.builder();
        private ImmutableMap.Builder<String, String> extraProperties = ImmutableMap.builder();
        private ImmutableMap.Builder<String, String> internalProperties = ImmutableMap.builder();
        private Instant expiresAt;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AccessConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllCredentials(instance.credentials());
            this.putAllExtraProperties(instance.extraProperties());
            this.putAllInternalProperties(instance.internalProperties());
            Optional<Instant> expiresAtOptional = instance.expiresAt();
            if (expiresAtOptional.isPresent()) {
                this.expiresAt(expiresAtOptional);
            }
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder putCredential(String key, String value) {
            this.credentials.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCredential(Map.Entry<String, ? extends String> entry) {
            this.credentials.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder credentials(Map<String, ? extends String> entries) {
            this.credentials = ImmutableMap.builder();
            return this.putAllCredentials(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCredentials(Map<String, ? extends String> entries) {
            this.credentials.putAll(entries);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder putExtraProperty(String key, String value) {
            this.extraProperties.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putExtraProperty(Map.Entry<String, ? extends String> entry) {
            this.extraProperties.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder extraProperties(Map<String, ? extends String> entries) {
            this.extraProperties = ImmutableMap.builder();
            return this.putAllExtraProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllExtraProperties(Map<String, ? extends String> entries) {
            this.extraProperties.putAll(entries);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder putInternalProperty(String key, String value) {
            this.internalProperties.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putInternalProperty(Map.Entry<String, ? extends String> entry) {
            this.internalProperties.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder internalProperties(Map<String, ? extends String> entries) {
            this.internalProperties = ImmutableMap.builder();
            return this.putAllInternalProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllInternalProperties(Map<String, ? extends String> entries) {
            this.internalProperties.putAll(entries);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = Objects.requireNonNull(expiresAt, "expiresAt");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expiresAt(Optional<? extends Instant> expiresAt) {
            this.expiresAt = expiresAt.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.credentials = ImmutableMap.builder();
            this.extraProperties = ImmutableMap.builder();
            this.internalProperties = ImmutableMap.builder();
            this.expiresAt = null;
            return this;
        }

        @Override
        public ImmutableAccessConfig build() {
            return new ImmutableAccessConfig((ImmutableMap<String, String>)this.credentials.build(), (ImmutableMap<String, String>)this.extraProperties.build(), (ImmutableMap<String, String>)this.internalProperties.build(), this.expiresAt);
        }
    }
}

