/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.seata.common.util.CycleDependencyHandler;
import org.apache.seata.common.util.StringUtils;

public class CollectionUtils {
    public static final String KV_SPLIT = "=";
    public static final String PAIR_SPLIT = "&";

    private CollectionUtils() {
    }

    public static boolean isEmpty(Collection<?> col) {
        return !CollectionUtils.isNotEmpty(col);
    }

    public static boolean isNotEmpty(Collection<?> col) {
        return col != null && !col.isEmpty();
    }

    public static boolean isEmpty(Object[] array) {
        return !CollectionUtils.isNotEmpty(array);
    }

    public static boolean isNotEmpty(Object[] array) {
        return array != null && array.length > 0;
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return !CollectionUtils.isNotEmpty(map);
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return map != null && !map.isEmpty();
    }

    public static String toString(Collection<?> col) {
        if (col == null) {
            return "null";
        }
        if (col.isEmpty()) {
            return "[]";
        }
        return CycleDependencyHandler.wrap(col, o -> {
            StringBuilder sb = new StringBuilder(32);
            sb.append("[");
            for (Object obj : col) {
                if (sb.length() > 1) {
                    sb.append(", ");
                }
                if (obj == col) {
                    sb.append("(this ").append(obj.getClass().getSimpleName()).append(")");
                    continue;
                }
                sb.append(StringUtils.toString(obj));
            }
            sb.append("]");
            return sb.toString();
        });
    }

    public static String toString(Map<?, ?> map) {
        if (map == null) {
            return "null";
        }
        if (map.isEmpty()) {
            return "{}";
        }
        return CycleDependencyHandler.wrap(map, o -> {
            StringBuilder sb = new StringBuilder(32);
            sb.append("{");
            map.forEach((key, value) -> {
                if (sb.length() > 1) {
                    sb.append(", ");
                }
                if (key == map) {
                    sb.append("(this ").append(map.getClass().getSimpleName()).append(")");
                } else {
                    sb.append(StringUtils.toString(key));
                }
                sb.append("->");
                if (value == map) {
                    sb.append("(this ").append(map.getClass().getSimpleName()).append(")");
                } else {
                    sb.append(StringUtils.toString(value));
                }
            });
            sb.append("}");
            return sb.toString();
        });
    }

    public static Map<String, String> toStringMap(Map<String, Object> param) {
        HashMap<String, String> covertMap = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(param)) {
            param.forEach((key, value) -> {
                if (value != null) {
                    if (value instanceof CharSequence || value instanceof Character) {
                        covertMap.put((String)key, value.toString());
                    } else {
                        covertMap.put((String)key, StringUtils.toString(value));
                    }
                }
            });
        }
        return covertMap;
    }

    public static boolean isSizeEquals(Collection<?> col0, Collection<?> col1) {
        if (col0 == null) {
            return col1 == null;
        }
        if (col1 == null) {
            return false;
        }
        return col0.size() == col1.size();
    }

    public static String encodeMap(Map<String, String> map) {
        if (map == null) {
            return null;
        }
        if (map.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append(entry.getKey()).append(KV_SPLIT).append(entry.getValue()).append(PAIR_SPLIT);
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static Map<String, String> decodeMap(String data) {
        if (data == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isBlank(data)) {
            return map;
        }
        String[] kvPairs = data.split(PAIR_SPLIT);
        if (kvPairs.length == 0) {
            return map;
        }
        for (String kvPair : kvPairs) {
            String[] kvs;
            if (StringUtils.isNullOrEmpty(kvPair) || (kvs = kvPair.split(KV_SPLIT)).length != 2) continue;
            map.put(kvs[0], kvs[1]);
        }
        return map;
    }

    public static <K, V> V computeIfAbsent(Map<K, V> map, K key, Function<? super K, ? extends V> mappingFunction) {
        V value = map.get(key);
        if (value != null) {
            return value;
        }
        return map.computeIfAbsent((K)key, mappingFunction);
    }

    public static List<String> toUpperList(List<String> sourceList) {
        if (CollectionUtils.isEmpty(sourceList)) {
            return sourceList;
        }
        ArrayList<String> destList = new ArrayList<String>(sourceList.size());
        for (String element : sourceList) {
            if (element != null) {
                destList.add(element.toUpperCase());
                continue;
            }
            destList.add(null);
        }
        return destList;
    }

    public static <T> T getLast(List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        int size;
        while ((size = list.size()) != 0) {
            try {
                return list.get(size - 1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                continue;
            }
            break;
        }
        return null;
    }

    public static String mapToJsonString(Map<String, Object> map) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        int i = 0;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("\"").append(entry.getKey()).append("\": ");
            if (entry.getValue() instanceof HashMap) {
                HashMap objectHashMap = (HashMap)entry.getValue();
                sb.append(CollectionUtils.mapToJsonString(objectHashMap));
            } else if (entry.getValue() instanceof String) {
                sb.append("\"");
                sb.append(entry.getValue());
                sb.append("\"");
            } else {
                sb.append(entry.getValue());
            }
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }
}

