/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.serializer;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.fury.Fury;
import org.apache.fury.codegen.Expression;
import org.apache.fury.memory.LittleEndian;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.memory.Platform;
import org.apache.fury.reflect.ReflectionUtils;
import org.apache.fury.serializer.ImmutableSerializer;
import org.apache.fury.serializer.StringUTF16;
import org.apache.fury.type.Type;
import org.apache.fury.type.TypeUtils;
import org.apache.fury.util.MathUtils;
import org.apache.fury.util.Preconditions;
import org.apache.fury.util.StringUtils;
import org.apache.fury.util.unsafe._JDKAccess;

public final class StringSerializer
extends ImmutableSerializer<String> {
    private static final boolean STRING_VALUE_FIELD_IS_CHARS;
    private static final boolean STRING_VALUE_FIELD_IS_BYTES;
    private static final byte LATIN1 = 0;
    private static final Byte LATIN1_BOXED;
    private static final byte UTF16 = 1;
    private static final Byte UTF16_BOXED;
    private static final byte UTF8 = 2;
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private static final long STRING_VALUE_FIELD_OFFSET;
    private final boolean compressString;
    private byte[] byteArray = new byte[1024];
    private int smoothByteArrayLength = 1024;
    private static final MethodHandles.Lookup STRING_LOOK_UP;
    private static final BiFunction<char[], Boolean, String> CHARS_STRING_ZERO_COPY_CTR;
    private static final BiFunction<byte[], Byte, String> BYTES_STRING_ZERO_COPY_CTR;
    private static final Function<byte[], String> LATIN_BYTES_STRING_ZERO_COPY_CTR;

    public StringSerializer(Fury fury) {
        super(fury, String.class, fury.trackingRef() && !fury.isStringRefIgnored());
        this.compressString = fury.compressString();
    }

    @Override
    public short getXtypeId() {
        return Type.STRING.getId();
    }

    @Override
    public void write(MemoryBuffer buffer, String value) {
        this.writeJavaString(buffer, value);
    }

    @Override
    public void xwrite(MemoryBuffer buffer, String value) {
        this.writeUTF8String(buffer, value);
    }

    @Override
    public String read(MemoryBuffer buffer) {
        return this.readJavaString(buffer);
    }

    @Override
    public String xread(MemoryBuffer buffer) {
        return this.readUTF8String(buffer);
    }

    public void writeString(MemoryBuffer buffer, String value) {
        if (this.isJava) {
            this.writeJavaString(buffer, value);
        } else {
            this.writeUTF8String(buffer, value);
        }
    }

    public Expression writeStringExpr(Expression strSerializer, Expression buffer, Expression str) {
        if (this.isJava) {
            if (STRING_VALUE_FIELD_IS_BYTES) {
                return new Expression.StaticInvoke(StringSerializer.class, "writeBytesString", buffer, str);
            }
            if (!STRING_VALUE_FIELD_IS_CHARS) {
                throw new UnsupportedOperationException();
            }
            if (this.compressString) {
                return new Expression.Invoke(strSerializer, "writeCharsStringCompressed", buffer, str);
            }
            return new Expression.Invoke(strSerializer, "writeCharsStringUncompressed", buffer, str);
        }
        return new Expression.Invoke(strSerializer, "writeUTF8String", buffer, str);
    }

    public void writeCharsStringCompressed(MemoryBuffer buffer, String value) {
        char[] chars = (char[])Platform.getObject(value, STRING_VALUE_FIELD_OFFSET);
        if (StringUtils.isLatin(chars)) {
            this.writeCharsLatin(buffer, chars, chars.length);
        } else {
            this.writeCharsUTF16(buffer, chars, chars.length);
        }
    }

    public void writeCharsStringUncompressed(MemoryBuffer buffer, String value) {
        int numBytes = MathUtils.doubleExact(value.length());
        char[] chars = (char[])Platform.getObject(value, STRING_VALUE_FIELD_OFFSET);
        buffer.writePrimitiveArrayWithSize(chars, Platform.CHAR_ARRAY_OFFSET, numBytes);
    }

    public String readString(MemoryBuffer buffer) {
        if (this.isJava) {
            return this.readJavaString(buffer);
        }
        return this.readUTF8String(buffer);
    }

    public Expression readStringExpr(Expression strSerializer, Expression buffer) {
        if (this.isJava) {
            if (STRING_VALUE_FIELD_IS_BYTES) {
                return new Expression.Invoke(strSerializer, "readBytesString", TypeUtils.STRING_TYPE, buffer);
            }
            if (!STRING_VALUE_FIELD_IS_CHARS) {
                throw new UnsupportedOperationException();
            }
            if (this.compressString) {
                return new Expression.Invoke(strSerializer, "readCompressedCharsString", TypeUtils.STRING_TYPE, buffer);
            }
            Expression.Invoke chars = new Expression.Invoke(buffer, "readCharsAndSize", TypeUtils.PRIMITIVE_CHAR_ARRAY_TYPE);
            return new Expression.StaticInvoke(StringSerializer.class, "newCharsStringZeroCopy", TypeUtils.STRING_TYPE, chars);
        }
        return new Expression.Invoke(strSerializer, "readUTF8String", TypeUtils.STRING_TYPE, buffer);
    }

    public String readBytesString(MemoryBuffer buffer) {
        byte[] bytes;
        long header = buffer.readVarUint36Small();
        byte coder = (byte)(header & 3L);
        int numBytes = (int)(header >>> 2);
        buffer.checkReadableBytes(numBytes);
        byte[] heapMemory = buffer.getHeapMemory();
        if (heapMemory != null) {
            int arrIndex = buffer._unsafeHeapReaderIndex();
            buffer.increaseReaderIndex(numBytes);
            bytes = new byte[numBytes];
            System.arraycopy(heapMemory, arrIndex, bytes, 0, numBytes);
        } else {
            bytes = buffer.readBytes(numBytes);
        }
        if (coder != 2) {
            return StringSerializer.newBytesStringZeroCopy(coder, bytes);
        }
        return new String(bytes, 0, numBytes, StandardCharsets.UTF_8);
    }

    public String readCompressedCharsString(MemoryBuffer buffer) {
        long header = buffer.readVarUint36Small();
        byte coder = (byte)(header & 3L);
        int numBytes = (int)(header >>> 2);
        if (coder == 0) {
            return StringSerializer.newCharsStringZeroCopy(this.readLatinChars(buffer, numBytes));
        }
        if (coder == 1) {
            return StringSerializer.newCharsStringZeroCopy(this.readUTF16Chars(buffer, numBytes));
        }
        return this.readUtf8(buffer, coder, numBytes);
    }

    private String readUtf8(MemoryBuffer buffer, byte coder, int numBytes) {
        Preconditions.checkArgument(coder == 2, (byte)2);
        byte[] bytes = buffer.readBytes(numBytes);
        return new String(bytes, 0, numBytes, StandardCharsets.UTF_8);
    }

    private byte[] getByteArray(int numElements) {
        byte[] byteArray = this.byteArray;
        if (byteArray.length < numElements) {
            this.byteArray = byteArray = new byte[numElements];
        }
        if (byteArray.length > 1024) {
            this.smoothByteArrayLength = Math.max((int)((double)this.smoothByteArrayLength * 0.9 + (double)numElements * 0.1), 1024);
            if (this.smoothByteArrayLength <= 1024) {
                this.byteArray = new byte[1024];
            }
        }
        return byteArray;
    }

    public void writeJavaString(MemoryBuffer buffer, String value) {
        if (STRING_VALUE_FIELD_IS_BYTES) {
            StringSerializer.writeBytesString(buffer, value);
        } else {
            assert (STRING_VALUE_FIELD_IS_CHARS);
            char[] chars = (char[])Platform.getObject(value, STRING_VALUE_FIELD_OFFSET);
            if (this.compressString) {
                if (StringUtils.isLatin(chars)) {
                    this.writeCharsLatin(buffer, chars, chars.length);
                } else {
                    this.writeCharsUTF16(buffer, chars, chars.length);
                }
            } else {
                int numBytes = MathUtils.doubleExact(value.length());
                buffer.writePrimitiveArrayWithSize(chars, Platform.CHAR_ARRAY_OFFSET, numBytes);
            }
        }
    }

    public String readJavaString(MemoryBuffer buffer) {
        if (STRING_VALUE_FIELD_IS_BYTES) {
            return this.readBytesString(buffer);
        }
        assert (STRING_VALUE_FIELD_IS_CHARS);
        if (this.compressString) {
            return this.readCompressedCharsString(buffer);
        }
        return StringSerializer.newCharsStringZeroCopy(buffer.readCharsAndSize());
    }

    public static void writeBytesString(MemoryBuffer buffer, String value) {
        byte[] bytes = (byte[])Platform.getObject(value, STRING_VALUE_FIELD_OFFSET);
        int bytesLen = bytes.length;
        long header = (long)bytesLen << 2 | (long)Platform.getByte(value, Offset.STRING_CODER_FIELD_OFFSET);
        int writerIndex = buffer.writerIndex();
        buffer.ensure(writerIndex + 9 + bytesLen);
        byte[] targetArray = buffer.getHeapMemory();
        if (targetArray != null) {
            int targetIndex;
            int arrIndex = targetIndex = buffer._unsafeHeapWriterIndex();
            arrIndex += LittleEndian.putVarUint36Small(targetArray, arrIndex, header);
            writerIndex += arrIndex - targetIndex;
            System.arraycopy(bytes, 0, targetArray, arrIndex, bytesLen);
        } else {
            writerIndex += buffer._unsafePutVarUint36Small(writerIndex, header);
            long offHeapAddress = buffer.getUnsafeAddress();
            Platform.copyMemory(bytes, Platform.BYTE_ARRAY_OFFSET, null, offHeapAddress + (long)writerIndex, bytesLen);
        }
        buffer._unsafeWriterIndex(writerIndex += bytesLen);
    }

    public void writeCharsLatin(MemoryBuffer buffer, char[] chars, int strLen) {
        int writerIndex = buffer.writerIndex();
        buffer.ensure(writerIndex + 9 + strLen);
        long header = (long)strLen << 2 | 0L;
        byte[] targetArray = buffer.getHeapMemory();
        if (targetArray != null) {
            int arrIndex = buffer._unsafeHeapWriterIndex();
            int written = LittleEndian.putVarUint36Small(targetArray, arrIndex, header);
            arrIndex += written;
            writerIndex += written + strLen;
            for (int i = 0; i < strLen; ++i) {
                targetArray[arrIndex + i] = (byte)chars[i];
            }
            buffer._unsafeWriterIndex(writerIndex);
        } else {
            writerIndex += buffer._unsafePutVarUint36Small(writerIndex, header);
            byte[] tmpArray = this.getByteArray(strLen);
            for (int i = 0; i < strLen; ++i) {
                tmpArray[i] = (byte)chars[i];
            }
            buffer.put(writerIndex, tmpArray, 0, strLen);
            buffer._unsafeWriterIndex(writerIndex += strLen);
        }
    }

    public void writeCharsUTF16(MemoryBuffer buffer, char[] chars, int strLen) {
        int numBytes = MathUtils.doubleExact(strLen);
        long header = (long)numBytes << 2 | 1L;
        int writerIndex = buffer.writerIndex();
        buffer.ensure(writerIndex + 9 + numBytes);
        byte[] targetArray = buffer.getHeapMemory();
        if (targetArray != null) {
            int arrIndex = buffer._unsafeHeapWriterIndex();
            int written = LittleEndian.putVarUint36Small(targetArray, arrIndex, header);
            arrIndex += written;
            writerIndex += written + numBytes;
            if (Platform.IS_LITTLE_ENDIAN) {
                Platform.UNSAFE.copyMemory(chars, Platform.CHAR_ARRAY_OFFSET, targetArray, Platform.BYTE_ARRAY_OFFSET + arrIndex, numBytes);
            } else {
                StringSerializer.heapWriteCharsUTF16BE(chars, arrIndex, numBytes, targetArray);
            }
        } else {
            writerIndex = this.offHeapWriteCharsUTF16(buffer, chars, writerIndex, header, numBytes);
        }
        buffer._unsafeWriterIndex(writerIndex);
    }

    private static void heapWriteCharsUTF16BE(char[] chars, int arrIndex, int numBytes, byte[] targetArray) {
        int i;
        int charIndex = 0;
        int end = i + numBytes;
        for (i = arrIndex; i < end; i += 2) {
            char c = chars[charIndex++];
            targetArray[i] = (byte)(c >> StringUTF16.HI_BYTE_SHIFT);
            targetArray[i + 1] = (byte)(c >> StringUTF16.LO_BYTE_SHIFT);
        }
    }

    private int offHeapWriteCharsUTF16(MemoryBuffer buffer, char[] chars, int writerIndex, long header, int numBytes) {
        writerIndex += buffer._unsafePutVarUint36Small(writerIndex, header);
        byte[] tmpArray = this.getByteArray(numBytes);
        int charIndex = 0;
        for (int i = 0; i < numBytes; i += 2) {
            char c = chars[charIndex++];
            tmpArray[i] = (byte)(c >> StringUTF16.HI_BYTE_SHIFT);
            tmpArray[i + 1] = (byte)(c >> StringUTF16.LO_BYTE_SHIFT);
        }
        buffer.put(writerIndex, tmpArray, 0, numBytes);
        return writerIndex += numBytes;
    }

    private char[] readLatinChars(MemoryBuffer buffer, int numBytes) {
        char[] chars = new char[numBytes];
        buffer.checkReadableBytes(numBytes);
        byte[] targetArray = buffer.getHeapMemory();
        if (targetArray != null) {
            int srcIndex = buffer._unsafeHeapReaderIndex();
            for (int i = 0; i < numBytes; ++i) {
                chars[i] = (char)(targetArray[srcIndex++] & 0xFF);
            }
            buffer._increaseReaderIndexUnsafe(numBytes);
        } else {
            byte[] byteArray = this.getByteArray(numBytes);
            buffer.readBytes(byteArray, 0, numBytes);
            for (int i = 0; i < numBytes; ++i) {
                chars[i] = (char)(byteArray[i] & 0xFF);
            }
        }
        return chars;
    }

    private char[] readUTF16Chars(MemoryBuffer buffer, int numBytes) {
        char[] chars = new char[numBytes >> 1];
        if (Platform.IS_LITTLE_ENDIAN) {
            buffer.readChars(chars, Platform.CHAR_ARRAY_OFFSET, numBytes);
        } else {
            buffer.checkReadableBytes(numBytes);
            byte[] targetArray = buffer.getHeapMemory();
            if (targetArray != null) {
                int i;
                int charIndex = 0;
                int end = i + numBytes;
                for (i = buffer._unsafeHeapReaderIndex(); i < end; i += 2) {
                    char c = (char)(targetArray[i] & 255 << StringUTF16.HI_BYTE_SHIFT | (targetArray[i + 1] & 0xFF) << StringUTF16.LO_BYTE_SHIFT);
                    chars[charIndex++] = c;
                }
                buffer._increaseReaderIndexUnsafe(numBytes);
            } else {
                byte[] tmpArray = this.getByteArray(numBytes);
                buffer.readBytes(tmpArray, 0, numBytes);
                int charIndex = 0;
                for (int i = 0; i < numBytes; i += 2) {
                    char c = (char)(tmpArray[i] & 255 << StringUTF16.HI_BYTE_SHIFT | (tmpArray[i + 1] & 0xFF) << StringUTF16.LO_BYTE_SHIFT);
                    chars[charIndex++] = c;
                }
            }
        }
        return chars;
    }

    public static String newCharsStringZeroCopy(char[] data) {
        if (!STRING_VALUE_FIELD_IS_CHARS) {
            throw new IllegalStateException("String value isn't char[], current java isn't supported");
        }
        return CHARS_STRING_ZERO_COPY_CTR.apply(data, Boolean.TRUE);
    }

    public static String newBytesStringZeroCopy(byte coder, byte[] data) {
        if (coder == 0) {
            if (LATIN_BYTES_STRING_ZERO_COPY_CTR != null) {
                return LATIN_BYTES_STRING_ZERO_COPY_CTR.apply(data);
            }
            return BYTES_STRING_ZERO_COPY_CTR.apply(data, LATIN1_BOXED);
        }
        if (coder == 1) {
            return BYTES_STRING_ZERO_COPY_CTR.apply(data, UTF16_BOXED);
        }
        return BYTES_STRING_ZERO_COPY_CTR.apply(data, coder);
    }

    private static BiFunction<char[], Boolean, String> getCharsStringZeroCopyCtr() {
        if (!STRING_VALUE_FIELD_IS_CHARS) {
            return null;
        }
        MethodHandle handle = StringSerializer.getJavaStringZeroCopyCtrHandle();
        if (handle == null) {
            return null;
        }
        try {
            CallSite callSite = LambdaMetafactory.metafactory(STRING_LOOK_UP, "apply", MethodType.methodType(BiFunction.class), handle.type().generic(), handle, handle.type());
            return callSite.getTarget().invokeExact();
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static BiFunction<byte[], Byte, String> getBytesStringZeroCopyCtr() {
        if (!STRING_VALUE_FIELD_IS_BYTES) {
            return null;
        }
        MethodHandle handle = StringSerializer.getJavaStringZeroCopyCtrHandle();
        if (handle == null) {
            return null;
        }
        try {
            MethodType instantiatedMethodType = MethodType.methodType(handle.type().returnType(), new Class[]{byte[].class, Byte.class});
            CallSite callSite = LambdaMetafactory.metafactory(STRING_LOOK_UP, "apply", MethodType.methodType(BiFunction.class), handle.type().generic(), handle, instantiatedMethodType);
            return callSite.getTarget().invokeExact();
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static Function<byte[], String> getLatinBytesStringZeroCopyCtr() {
        if (!STRING_VALUE_FIELD_IS_BYTES) {
            return null;
        }
        if (STRING_LOOK_UP == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName("java.lang.StringCoding");
            MethodHandles.Lookup caller = STRING_LOOK_UP.in(clazz);
            MethodHandle handle = caller.findStatic(clazz, "newStringLatin1", MethodType.methodType(String.class, byte[].class));
            return _JDKAccess.makeFunction(caller, handle, Function.class);
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static MethodHandle getJavaStringZeroCopyCtrHandle() {
        Preconditions.checkArgument(Platform.JAVA_VERSION >= 8);
        if (STRING_LOOK_UP == null) {
            return null;
        }
        try {
            if (STRING_VALUE_FIELD_IS_CHARS) {
                return STRING_LOOK_UP.findConstructor(String.class, MethodType.methodType(Void.TYPE, char[].class, Boolean.TYPE));
            }
            return STRING_LOOK_UP.findConstructor(String.class, MethodType.methodType(Void.TYPE, byte[].class, Byte.TYPE));
        }
        catch (Exception e) {
            return null;
        }
    }

    public void writeUTF8String(MemoryBuffer buffer, String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        buffer.writeVarUint32(bytes.length);
        buffer.writeBytes(bytes);
    }

    public String readUTF8String(MemoryBuffer buffer) {
        int numBytes = buffer.readVarUint32Small14();
        buffer.checkReadableBytes(numBytes);
        byte[] targetArray = buffer.getHeapMemory();
        if (targetArray != null) {
            String str = new String(targetArray, buffer._unsafeHeapReaderIndex(), numBytes, StandardCharsets.UTF_8);
            buffer.increaseReaderIndex(numBytes);
            return str;
        }
        byte[] tmpArray = this.getByteArray(numBytes);
        buffer.readBytes(tmpArray, 0, numBytes);
        return new String(tmpArray, 0, numBytes, StandardCharsets.UTF_8);
    }

    static {
        LATIN1_BOXED = 0;
        UTF16_BOXED = 1;
        Field valueField = ReflectionUtils.getFieldNullable(String.class, "value");
        STRING_VALUE_FIELD_IS_CHARS = valueField != null && valueField.getType() == char[].class;
        STRING_VALUE_FIELD_IS_BYTES = valueField != null && valueField.getType() == byte[].class;
        try {
            STRING_VALUE_FIELD_OFFSET = Platform.objectFieldOffset(String.class.getDeclaredField("value"));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        Preconditions.checkArgument(ReflectionUtils.getFieldNullable(String.class, "count") == null, "Current jdk not supported");
        Preconditions.checkArgument(ReflectionUtils.getFieldNullable(String.class, "offset") == null, "Current jdk not supported");
        STRING_LOOK_UP = _JDKAccess._trustedLookup(String.class);
        CHARS_STRING_ZERO_COPY_CTR = StringSerializer.getCharsStringZeroCopyCtr();
        BYTES_STRING_ZERO_COPY_CTR = StringSerializer.getBytesStringZeroCopyCtr();
        LATIN_BYTES_STRING_ZERO_COPY_CTR = StringSerializer.getLatinBytesStringZeroCopyCtr();
    }

    private static class Offset {
        private static final long STRING_CODER_FIELD_OFFSET;

        private Offset() {
        }

        static {
            try {
                STRING_CODER_FIELD_OFFSET = Platform.objectFieldOffset(String.class.getDeclaredField("coder"));
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

