/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.config;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.seata.common.thread.NamedThreadFactory;
import org.apache.seata.config.ConfigurationChangeEvent;

public interface ConfigurationChangeListener {
    public static final int CORE_LISTENER_THREAD = 1;
    public static final int MAX_LISTENER_THREAD = 1;
    public static final ExecutorService EXECUTOR_SERVICE = new ThreadPoolExecutor(1, 1, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("configListenerOperate", 1));

    public void onChangeEvent(ConfigurationChangeEvent var1);

    default public void onProcessEvent(ConfigurationChangeEvent event) {
        this.getExecutorService().submit(() -> {
            this.beforeEvent(event);
            this.onChangeEvent(event);
            this.afterEvent(event);
        });
    }

    default public void onShutDown() {
        this.getExecutorService().shutdownNow();
    }

    default public ExecutorService getExecutorService() {
        return EXECUTOR_SERVICE;
    }

    default public void beforeEvent(ConfigurationChangeEvent event) {
    }

    default public void afterEvent(ConfigurationChangeEvent event) {
    }
}

