/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.storage.db.lock;

import javax.sql.DataSource;
import org.apache.seata.common.executor.Initialize;
import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.core.lock.Locker;
import org.apache.seata.core.store.db.DataSourceProvider;
import org.apache.seata.server.lock.AbstractLockManager;
import org.apache.seata.server.session.BranchSession;
import org.apache.seata.server.session.GlobalSession;
import org.apache.seata.server.storage.db.lock.DataBaseLocker;

@LoadLevel(name="db")
public class DataBaseLockManager
extends AbstractLockManager
implements Initialize {
    private Locker locker;

    public void init() {
        String datasourceType = ConfigurationFactory.getInstance().getConfig("store.db.datasource");
        DataSource lockStoreDataSource = ((DataSourceProvider)EnhancedServiceLoader.load(DataSourceProvider.class, (String)datasourceType)).provide();
        this.locker = new DataBaseLocker(lockStoreDataSource);
    }

    public boolean releaseLock(BranchSession branchSession) throws TransactionException {
        try {
            return this.getLocker().releaseLock(branchSession.getXid(), Long.valueOf(branchSession.getBranchId()));
        }
        catch (Exception t) {
            LOGGER.error("unLock error, xid {}, branchId:{}", new Object[]{branchSession.getXid(), branchSession.getBranchId(), t});
            return false;
        }
    }

    public Locker getLocker(BranchSession branchSession) {
        return this.locker;
    }

    public boolean releaseGlobalSessionLock(GlobalSession globalSession) throws TransactionException {
        try {
            return this.getLocker().releaseLock(globalSession.getXid());
        }
        catch (Exception t) {
            LOGGER.error("unLock globalSession error, xid:{}", (Object)globalSession.getXid(), (Object)t);
            return false;
        }
    }
}

