/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.common.util;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;

public class CycleDependencyHandler {
    private static final ThreadLocal<Set<Object>> OBJECT_SET_LOCAL = new ThreadLocal();

    public static boolean isStarting() {
        return OBJECT_SET_LOCAL.get() != null;
    }

    public static void start() {
        OBJECT_SET_LOCAL.set(new HashSet(8));
    }

    public static void end() {
        OBJECT_SET_LOCAL.remove();
    }

    public static void addObject(Object obj) {
        if (obj == null) {
            return;
        }
        Set<Object> objectSet = OBJECT_SET_LOCAL.get();
        objectSet.add(CycleDependencyHandler.getUniqueSubstituteObject(obj));
    }

    public static boolean containsObject(Object obj) {
        if (obj == null) {
            return false;
        }
        Set<Object> objectSet = OBJECT_SET_LOCAL.get();
        if (objectSet.isEmpty()) {
            return false;
        }
        return objectSet.contains(CycleDependencyHandler.getUniqueSubstituteObject(obj));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <O> String wrap(O obj, Function<O, String> function) {
        boolean isStarting = CycleDependencyHandler.isStarting();
        try {
            if (!isStarting) {
                CycleDependencyHandler.start();
            } else if (CycleDependencyHandler.containsObject(obj)) {
                String string = CycleDependencyHandler.toRefString(obj);
                return string;
            }
            CycleDependencyHandler.addObject(obj);
            String string = function.apply(obj);
            return string;
        }
        finally {
            if (!isStarting) {
                CycleDependencyHandler.end();
            }
        }
    }

    public static String toRefString(Object obj) {
        return "(ref " + obj.getClass().getSimpleName() + ")";
    }

    private static Object getUniqueSubstituteObject(Object obj) {
        return System.identityHashCode(obj);
    }
}

