/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.DecoratingProxy;
import org.springframework.core.OrderComparator;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.OrderUtils;
import org.springframework.lang.Nullable;

public class AnnotationAwareOrderComparator
extends OrderComparator {
    public static final AnnotationAwareOrderComparator INSTANCE = new AnnotationAwareOrderComparator();

    @Override
    @Nullable
    protected Integer findOrder(Object obj2) {
        Integer order2 = super.findOrder(obj2);
        if (order2 != null) {
            return order2;
        }
        return this.findOrderFromAnnotation(obj2);
    }

    @Nullable
    private Integer findOrderFromAnnotation(Object obj2) {
        MergedAnnotations annotations;
        Class<?> element2 = obj2 instanceof AnnotatedElement ? (Class<?>)obj2 : obj2.getClass();
        Integer order2 = OrderUtils.getOrderFromAnnotations(element2, annotations = MergedAnnotations.from(element2, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY));
        if (order2 == null && obj2 instanceof DecoratingProxy) {
            return this.findOrderFromAnnotation(((DecoratingProxy)obj2).getDecoratedClass());
        }
        return order2;
    }

    @Override
    @Nullable
    public Integer getPriority(Object obj2) {
        if (obj2 instanceof Class) {
            return OrderUtils.getPriority((Class)obj2);
        }
        Integer priority2 = OrderUtils.getPriority(obj2.getClass());
        if (priority2 == null && obj2 instanceof DecoratingProxy) {
            return this.getPriority(((DecoratingProxy)obj2).getDecoratedClass());
        }
        return priority2;
    }

    public static void sort(List<?> list2) {
        if (list2.size() > 1) {
            list2.sort(INSTANCE);
        }
    }

    public static void sort(Object[] array) {
        if (array.length > 1) {
            Arrays.sort(array, INSTANCE);
        }
    }

    public static void sortIfNecessary(Object value2) {
        if (value2 instanceof Object[]) {
            AnnotationAwareOrderComparator.sort((Object[])value2);
        } else if (value2 instanceof List) {
            AnnotationAwareOrderComparator.sort((List)value2);
        }
    }
}

