/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.init;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.datastax.oss.driver.api.querybuilder.schema.CreateKeyspace;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.james.backends.cassandra.init.configuration.KeyspaceConfiguration;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class KeyspaceFactory {
    public static Mono<Void> createKeyspace(KeyspaceConfiguration configuration, CqlSession session) {
        if (!KeyspaceFactory.keyspaceExist(session, configuration.getKeyspace())) {
            return Mono.from((Publisher)session.executeReactive((Statement)((CreateKeyspace)((CreateKeyspace)SchemaBuilder.createKeyspace((String)configuration.getKeyspace()).ifNotExists().withReplicationOptions((Map)ImmutableMap.builder().put((Object)"class", (Object)"SimpleStrategy").put((Object)"replication_factor", (Object)configuration.getReplicationFactor()).build())).withDurableWrites(configuration.isDurableWrites())).build())).then();
        }
        return Mono.empty();
    }

    @VisibleForTesting
    public static boolean keyspaceExist(CqlSession session, String keyspaceName) {
        return session.getMetadata().getKeyspaces().get(CqlIdentifier.fromCql((String)keyspaceName)) != null;
    }
}

