/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.jsieve;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.mail.MessagingException;
import org.apache.james.transport.mailets.jsieve.ActionContext;
import org.apache.james.transport.mailets.jsieve.DiscardAction;
import org.apache.james.transport.mailets.jsieve.FileIntoAction;
import org.apache.james.transport.mailets.jsieve.KeepAction;
import org.apache.james.transport.mailets.jsieve.MailAction;
import org.apache.james.transport.mailets.jsieve.RedirectAction;
import org.apache.james.transport.mailets.jsieve.RejectAction;
import org.apache.james.transport.mailets.jsieve.VacationAction;
import org.apache.jsieve.mail.Action;
import org.apache.jsieve.mail.ActionDiscard;
import org.apache.jsieve.mail.ActionFileInto;
import org.apache.jsieve.mail.ActionKeep;
import org.apache.jsieve.mail.ActionRedirect;
import org.apache.jsieve.mail.ActionReject;
import org.apache.jsieve.mail.optional.ActionVacation;
import org.apache.mailet.Mail;

public class ActionDispatcher {
    private ConcurrentMap<Class<?>, MailAction> fieldMailActionMap;

    public ActionDispatcher() {
        this.setMethodMap(this.defaultMethodMap());
    }

    public void execute(Action anAction, Mail aMail, ActionContext context) throws MessagingException {
        MailAction mailAction = (MailAction)this.getMethodMap().get(anAction.getClass());
        mailAction.execute(anAction, aMail, context);
    }

    public ConcurrentMap<Class<?>, MailAction> getMethodMap() {
        return this.fieldMailActionMap;
    }

    private ConcurrentMap<Class<?>, MailAction> defaultMethodMap() {
        ConcurrentHashMap actionMap = new ConcurrentHashMap(4);
        actionMap.put(ActionFileInto.class, new FileIntoAction());
        actionMap.put(ActionKeep.class, new KeepAction());
        actionMap.put(ActionRedirect.class, new RedirectAction());
        actionMap.put(ActionReject.class, new RejectAction());
        actionMap.put(ActionVacation.class, new VacationAction());
        actionMap.put(ActionDiscard.class, new DiscardAction());
        return actionMap;
    }

    protected void setMethodMap(ConcurrentMap<Class<?>, MailAction> mailActionMap) {
        this.fieldMailActionMap = mailActionMap;
    }
}

