/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.servlet.jsp.JspWriter;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.rss.RSSGenerator;
import org.apache.wiki.tags.WikiTagBase;

public class RSSImageLinkTag
extends WikiTagBase {
    private static final long serialVersionUID = 0L;
    protected String m_title;
    private String m_mode;
    private String m_pageName;

    @Override
    public void initTag() {
        super.initTag();
        this.m_title = null;
        this.m_mode = "full";
        this.m_pageName = null;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    public void setMode(String mode) {
        this.m_mode = mode;
    }

    public String getTitle() {
        return this.m_title;
    }

    @Override
    public final int doWikiStartTag() throws IOException {
        Engine engine = this.m_wikiContext.getEngine();
        JspWriter out = this.pageContext.getOut();
        ResourceBundle rb = Preferences.getBundle(this.m_wikiContext, "CoreResources");
        if (engine.getManager(RSSGenerator.class) != null && ((RSSGenerator)engine.getManager(RSSGenerator.class)).isEnabled()) {
            if ("full".equals(this.m_mode)) {
                String rssURL = engine.getGlobalRSSURL();
                if (rssURL != null) {
                    out.print("<a class=\"feed\" href=\"" + rssURL);
                    out.print(" title='" + rb.getString("rss.title.full") + "'>");
                    out.print("&nbsp;</a> ");
                }
            } else {
                String page = this.m_pageName != null ? this.m_pageName : this.m_wikiContext.getPage().getName();
                String params = "page=" + page + "&mode=" + this.m_mode;
                out.print("<a href='" + this.m_wikiContext.getURL(ContextEnum.PAGE_NONE.getRequestContext(), "rss.jsp", params));
                out.print("' class='feed'");
                out.print(" title='" + MessageFormat.format(rb.getString("rss.title"), page) + "'>");
                out.print("&nbsp;</a> ");
            }
        }
        return 0;
    }
}

