/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.util.TextUtil;

public abstract class WikiTagBase
extends TagSupport
implements TryCatchFinally {
    private static final long serialVersionUID = -1409836349293777141L;
    private static final Logger LOG = LogManager.getLogger(WikiTagBase.class);
    protected Context m_wikiContext;

    public void setPageContext(PageContext arg0) {
        super.setPageContext(arg0);
        this.initTag();
    }

    public void initTag() {
        this.m_wikiContext = null;
    }

    public int doStartTag() throws JspException {
        try {
            this.m_wikiContext = (Context)this.pageContext.getAttribute("jspwiki.context", 2);
            if (this.m_wikiContext == null) {
                throw new JspException("WikiContext may not be NULL - serious internal problem!");
            }
            return this.doWikiStartTag();
        }
        catch (Exception e) {
            LOG.error("Tag failed", (Throwable)e);
            throw new JspException("Tag failed, check logs: " + e.getMessage());
        }
    }

    public abstract int doWikiStartTag() throws Exception;

    public int doEndTag() throws JspException {
        return 6;
    }

    public void doCatch(Throwable th) throws Throwable {
        LOG.error(th.getMessage(), th);
    }

    public void doFinally() {
        this.m_wikiContext = null;
    }

    public void setId(String id) {
        super.setId(TextUtil.replaceEntities((String)id));
    }
}

