/*
 * Decompiled with CFR 0.152.
 */
package org.freshcookies.security.cert;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.freshcookies.security.cert.CertificateDN;

public class Trustee {
    private boolean certsAdded = false;
    private final X509TrustManager sslTrustManager;
    private String trustedCAPath;
    private final KeyStore trustedCAStore = this.initSystemCAStore();

    public Trustee() {
        this.sslTrustManager = this.initSSLTrustManager();
    }

    public static String getAlias(X509Certificate cert) {
        CertificateDN dn = new CertificateDN(cert.getSubjectDN());
        if (dn.getCommonName() != null) {
            return dn.getCommonName();
        }
        if (dn.getOrganizationalUnit() != null) {
            return dn.getOrganizationalUnit() + "-" + cert.getSerialNumber().toString();
        }
        if (dn.getDomainComponent() != null) {
            return dn.getDomainComponent() + "-" + cert.getSerialNumber().toString();
        }
        return cert.getSerialNumber().toString();
    }

    public static String getCertificateInfo(X509Certificate cert) {
        String date = DateFormat.getDateInstance(2).format(cert.getNotBefore());
        String info = "Creation date: " + date + "\n";
        info = info + "Owner:\n";
        CertificateDN s = new CertificateDN(cert.getSubjectDN());
        info = info + (s.getCommonName() != null ? "         CN=" + s.getCommonName() + "\n" : "");
        info = info + (s.getOrganization() != null ? "         O=" + s.getOrganization() + "\n" : "");
        info = info + (s.getOrganizationalUnit() != null ? "         OU=" + s.getOrganizationalUnit() + "\n" : "");
        info = info + (s.getDomainComponent() != null ? "         DC=" + s.getDomainComponent() + "\n" : "");
        info = info + (s.getLocality() != null ? "         L=" + s.getLocality() + "\n" : "");
        info = info + (s.getState() != null ? "         S=" + s.getState() + "\n" : "");
        info = info + (s.getCountry() != null ? "         C=" + s.getCountry() + "\n" : "");
        info = info + (s.getEmail() != null ? "         E=" + s.getEmail() + "\n" : "");
        info = info + "Issuer:\n";
        s = new CertificateDN(cert.getIssuerDN());
        info = info + (s.getCommonName() != null ? "         CN=" + s.getCommonName() + "\n" : "");
        info = info + (s.getOrganization() != null ? "         O=" + s.getOrganization() + "\n" : "");
        info = info + (s.getOrganizationalUnit() != null ? "         OU=" + s.getOrganizationalUnit() + "\n" : "");
        info = info + (s.getDomainComponent() != null ? "         DC=" + s.getDomainComponent() + "\n" : "");
        info = info + (s.getLocality() != null ? "         L=" + s.getLocality() + "\n" : "");
        info = info + (s.getState() != null ? "         S=" + s.getState() + "\n" : "");
        info = info + (s.getCountry() != null ? "         C=" + s.getCountry() + "\n" : "");
        info = info + (s.getEmail() != null ? "         E=" + s.getEmail() + "\n" : "");
        info = info + "Serial number: " + cert.getSerialNumber() + "\n";
        info = info + "Valid from: " + cert.getNotBefore() + " until: " + cert.getNotAfter() + "\n";
        info = info + "Certificate fingerprints:\n";
        info = info + "         MD5:  " + Trustee.getCertFingerPrint("MD5", cert) + "\n";
        info = info + "         SHA1: " + Trustee.getCertFingerPrint("SHA1", cert) + "\n";
        return info;
    }

    private static void byte2hex(byte byte0, StringBuffer stringbuffer) {
        char[] ac = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int i = (byte0 & 0xF0) >> 4;
        int j = byte0 & 0xF;
        stringbuffer.append(ac[i]);
        stringbuffer.append(ac[j]);
    }

    private static String getCertFingerPrint(String s, Certificate certificate) {
        try {
            byte[] abyte0 = certificate.getEncoded();
            MessageDigest messagedigest = MessageDigest.getInstance(s);
            byte[] abyte1 = messagedigest.digest(abyte0);
            return Trustee.toHexString(abyte1);
        }
        catch (Exception e) {
            return "(error)";
        }
    }

    private static String toHexString(byte[] abyte0) {
        StringBuffer stringbuffer = new StringBuffer();
        int i = abyte0.length;
        for (int j = 0; j < i; ++j) {
            Trustee.byte2hex(abyte0[j], stringbuffer);
            if (j >= i - 1) continue;
            stringbuffer.append(":");
        }
        return stringbuffer.toString();
    }

    public boolean trustCACertificate(X509Certificate cert) throws KeyStoreException {
        if (!this.isTrustedCA(cert)) {
            System.out.println("This is a CA certificate. It is NOT trusted.");
            try {
                if (this.yesResponse("Do you want to trust this certificate?")) {
                    String alias = Trustee.getAlias(cert);
                    System.out.println("Adding CA to trust store with alias " + alias);
                    this.trustedCAStore.setCertificateEntry(alias, cert);
                    System.out.println("..success");
                    this.certsAdded = true;
                    return true;
                }
            }
            catch (IOException e) {
                System.out.println("Could not add certificate: " + e.getLocalizedMessage());
                return false;
            }
        }
        System.out.println("This is a CA certificate. It is already trusted.");
        return false;
    }

    public boolean commit() {
        if (!this.certsAdded) {
            System.err.println("No need to commit (no certificates added).");
            return false;
        }
        try {
            File file = new File(this.trustedCAPath);
            if (file.canWrite()) {
                FileOutputStream out = new FileOutputStream(this.trustedCAPath);
                this.trustedCAStore.store(out, "changeit".toCharArray());
                ((OutputStream)out).close();
                return true;
            }
            System.out.println("FATAL: You do not have write privileges to the Java JSSE trust store " + this.trustedCAPath + "\n\nTry running the application using sudo, or as root.\n");
        }
        catch (CertificateException e) {
            System.out.println("Certificate exception: " + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("No such algorithm: " + e.getMessage());
        }
        catch (KeyStoreException e) {
            System.out.println("Keystore exception: " + e.getMessage());
        }
        catch (IOException e) {
            System.out.println("IO exception: " + e.getMessage());
        }
        return false;
    }

    public void saveCertificate(X509Certificate cert) throws IOException, CertificateEncodingException {
        String alias = Trustee.getAlias(cert);
        alias = alias.replaceAll("[,\\.\\\\/]", "");
        String file = System.getProperty("user.dir") + "/" + alias + ".cer";
        FileOutputStream out = new FileOutputStream(file);
        out.write(cert.getEncoded());
        out.close();
        System.out.println("Saved certificate as " + file);
    }

    private X509TrustManager initSSLTrustManager() {
        TrustManager[] managers = new TrustManager[]{};
        try {
            TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            factory.init(this.trustedCAStore);
            managers = factory.getTrustManagers();
        }
        catch (KeyStoreException e) {
            System.out.println("Could not initialize trust manager with system keystore: " + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("No such algorithm: " + e.getMessage());
        }
        for (int i = 0; i < managers.length; ++i) {
            if (!(managers[i] instanceof X509TrustManager)) continue;
            return (X509TrustManager)managers[i];
        }
        return null;
    }

    private KeyStore initSystemCAStore() {
        this.trustedCAPath = System.getProperty("javax.net.ssl.trustStore");
        if (this.trustedCAPath == null) {
            this.trustedCAPath = System.getProperty("java.home") + "/lib/security/cacerts";
        }
        KeyStore store = null;
        try {
            store = KeyStore.getInstance(KeyStore.getDefaultType());
            FileInputStream fis = new FileInputStream(this.trustedCAPath);
            System.out.println("Locating certificate trust store: " + this.trustedCAPath);
            store.load(fis, "changeit".toCharArray());
            ((InputStream)fis).close();
        }
        catch (FileNotFoundException e) {
            System.out.println("Could not open keystore file: " + e.getMessage());
        }
        catch (IOException e) {
            System.out.println("IO exception: " + e.getMessage());
        }
        catch (CertificateException e) {
            System.out.println("Certificate exception: " + e.getMessage());
        }
        catch (KeyStoreException e) {
            System.out.println("Could not get keystore: " + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("No such algorithm: " + e.getMessage());
        }
        return store;
    }

    private boolean isTrustedCA(X509Certificate cert) {
        X509Certificate[] trustedCAs = this.sslTrustManager.getAcceptedIssuers();
        boolean isCertTrusted = false;
        for (int j = 0; j < trustedCAs.length; ++j) {
            if (!cert.equals(trustedCAs[j])) continue;
            isCertTrusted = true;
            break;
        }
        return isCertTrusted;
    }

    private synchronized boolean yesResponse(String prompt) throws IOException {
        String response = " ";
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        while (!"YES".equals(response) && !"NO".equals(response)) {
            System.out.print(prompt + " (yes/no): ");
            response = reader.readLine().toUpperCase().trim();
        }
        return "YES".equals(response);
    }
}

