/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.htmltowiki.syntax;

import java.io.PrintWriter;
import java.util.Deque;
import org.apache.wiki.htmltowiki.XHtmlElementToWikiTranslator;
import org.apache.wiki.htmltowiki.syntax.PlainTextCssSpecialDecorator;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public abstract class PlainTextMonospaceDecorator {
    protected final PrintWriter out;
    protected final Deque<String> preStack;
    protected final XHtmlElementToWikiTranslator chain;
    protected final PlainTextCssSpecialDecorator ptcsd;

    protected PlainTextMonospaceDecorator(PlainTextCssSpecialDecorator ptcsd, PrintWriter out, Deque<String> preStack, XHtmlElementToWikiTranslator chain) {
        this.out = out;
        this.preStack = preStack;
        this.chain = chain;
        this.ptcsd = ptcsd;
    }

    public void decorate(XHtmlElementToWikiTranslator.ElementDecoratorData dto) throws JDOMException {
        if (dto.monospace) {
            this.out.print(this.markupMonospaceOpen());
            this.preStack.addFirst(this.markupMonospaceOpen());
        }
        this.ptcsd.decorate(dto);
        if (dto.monospace) {
            this.preStack.removeFirst();
            this.out.print(this.markupMonospaceClose());
        }
    }

    public void decorate(Element e) throws JDOMException {
        this.out.print("\n" + this.markupMonospaceOpen());
        this.preStack.push("\n" + this.markupMonospaceOpen());
        this.chain.translate((Content)e);
        this.preStack.pop();
        this.out.print(this.markupMonospaceClose() + "\n");
    }

    protected abstract String markupMonospaceOpen();

    protected abstract String markupMonospaceClose();
}

