/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.htmltowiki.syntax;

import java.io.PrintWriter;
import org.apache.wiki.htmltowiki.XHtmlElementToWikiTranslator;
import org.apache.wiki.htmltowiki.syntax.MarkupHelper;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public abstract class TextAreaDecorator {
    protected final PrintWriter out;
    protected final XHtmlElementToWikiTranslator chain;

    protected TextAreaDecorator(PrintWriter out, XHtmlElementToWikiTranslator chain) {
        this.out = out;
        this.chain = chain;
    }

    public void decorate(Element e) throws JDOMException {
        String name = MarkupHelper.nameSansNbf(e);
        String rows = e.getAttributeValue("rows");
        String cols = e.getAttributeValue("cols");
        this.out.print(this.markupTextAreaOpen());
        this.printAttribute("name", name);
        this.printAttribute("rows", rows);
        this.printAttribute("cols", cols);
        this.out.print(this.markupTextAreaClose());
        this.chain.translate((Content)e);
    }

    void printAttribute(String attr, String value) {
        if (value != null) {
            this.out.print(this.markupForTextAreaAttribute(attr, value));
        }
    }

    protected abstract String markupForTextAreaAttribute(String var1, String var2);

    protected abstract String markupTextAreaOpen();

    protected abstract String markupTextAreaClose();
}

