/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.providers.PageProvider;
import org.apache.wiki.api.search.QueryItem;
import org.apache.wiki.api.search.SearchResult;
import org.apache.wiki.api.spi.Wiki;

public class CounterProvider
implements PageProvider {
    public int m_getPageCalls;
    public int m_pageExistsCalls;
    public int m_getPageTextCalls;
    public int m_getAllPagesCalls;
    public int m_initCalls;
    Page[] m_pages = new Page[0];
    String m_defaultText = "[Foo], [Bar], [Blat], [Blah]";

    public void initialize(Engine engine, Properties props) {
        this.m_pages = new Page[]{Wiki.contents().page(engine, "Foo"), Wiki.contents().page(engine, "Bar"), Wiki.contents().page(engine, "Blat"), Wiki.contents().page(engine, "Blaa")};
        ++this.m_initCalls;
        for (Page m_page : this.m_pages) {
            m_page.setAuthor("Unknown");
            m_page.setLastModified(new Date(0L));
            m_page.setVersion(1);
        }
    }

    public String getProviderInfo() {
        return "Very Simple Provider.";
    }

    public void putPageText(Page page, String text) throws ProviderException {
    }

    public boolean pageExists(String page) {
        ++this.m_pageExistsCalls;
        return this.findPage(page) != null;
    }

    public boolean pageExists(String page, int version) {
        return this.pageExists(page);
    }

    public Collection<SearchResult> findPages(QueryItem[] query) {
        return null;
    }

    private Page findPage(String page) {
        for (Page m_page : this.m_pages) {
            if (!m_page.getName().equals(page)) continue;
            return m_page;
        }
        return null;
    }

    public Page getPageInfo(String page, int version) {
        ++this.m_getPageCalls;
        return this.findPage(page);
    }

    public Collection<Page> getAllPages() {
        ++this.m_getAllPagesCalls;
        ArrayList<Page> l = new ArrayList<Page>();
        Collections.addAll(l, this.m_pages);
        return l;
    }

    public Collection<Page> getAllChangedSince(Date date) {
        return new ArrayList<Page>();
    }

    public int getPageCount() {
        return this.m_pages.length;
    }

    public List<Page> getVersionHistory(String page) {
        return new Vector<Page>();
    }

    public String getPageText(String page, int version) {
        ++this.m_getPageTextCalls;
        return this.m_defaultText;
    }

    public void deleteVersion(String page, int version) {
    }

    public void deletePage(String page) {
    }

    public void movePage(String from, String to) throws ProviderException {
    }
}

