/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import jakarta.xml.bind.DatatypeConverter;
import java.lang.ref.SoftReference;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.common.internal.ThrowableUtils;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.FieldInfo;

public final class DateUtils {
    public static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String PATTERN_RFC1036 = "EEE, dd-MMM-yy HH:mm:ss zzz";
    public static final String PATTERN_ASCTIME = "EEE MMM d HH:mm:ss yyyy";
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");

    public static Calendar parseISO8601Calendar(String s) {
        if (StringUtils.isEmpty(s)) {
            return null;
        }
        return DatatypeConverter.parseDateTime((String)DateUtils.toValidISO8601DT(s));
    }

    public static String formatDate(Date date, String pattern) {
        SimpleDateFormat formatter = DateFormatHolder.formatFor(pattern);
        return formatter.format(date);
    }

    public static void clearThreadLocal() {
        DateFormatHolder.clearThreadLocal();
    }

    public static String toValidISO8601DT(String in) {
        boolean S1 = true;
        int S2 = 2;
        int S3 = 3;
        int S4 = 4;
        int S5 = 5;
        int S6 = 6;
        int state = 1;
        boolean needsT = false;
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (state == 1) {
                if (c != '-') continue;
                state = 2;
                continue;
            }
            if (state == 2) {
                if (c != '-') continue;
                state = 3;
                continue;
            }
            if (state == 3) {
                if (c == 'T') {
                    state = 4;
                }
                if (c != ' ') continue;
                state = 4;
                needsT = true;
                continue;
            }
            if (state == 4) {
                if (c != ':') continue;
                state = 5;
                continue;
            }
            if (state != 5 || c != ':') continue;
            state = 6;
        }
        if (needsT) {
            in = in.replace(' ', 'T');
        }
        switch (state) {
            case 1: {
                return in + "-01-01T00:00:00";
            }
            case 2: {
                return in + "-01T00:00:00";
            }
            case 3: {
                return in + "T00:00:00";
            }
            case 4: {
                return in + ":00:00";
            }
            case 5: {
                return in + ":00";
            }
        }
        return in;
    }

    public static DateTimeFormatter getFormatter(String pattern) {
        if (StringUtils.isEmpty(pattern)) {
            return DateTimeFormatter.ISO_INSTANT;
        }
        try {
            FieldInfo fi = ClassInfo.of(DateTimeFormatter.class).getPublicField(x -> x.isStatic() && x.hasName(pattern));
            if (fi != null) {
                return (DateTimeFormatter)fi.inner().get(null);
            }
            return DateTimeFormatter.ofPattern(pattern);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw ThrowableUtils.asRuntimeException(e);
        }
    }

    static {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(GMT);
        calendar.set(2000, 0, 1, 0, 0, 0);
        calendar.set(14, 0);
    }

    static final class DateFormatHolder {
        private static final ThreadLocal<SoftReference<Map<String, SimpleDateFormat>>> THREADLOCAL_FORMATS = new ThreadLocal<SoftReference<Map<String, SimpleDateFormat>>>(){

            @Override
            protected SoftReference<Map<String, SimpleDateFormat>> initialValue() {
                HashMap m = new HashMap();
                return new SoftReference<Map<String, SimpleDateFormat>>(m);
            }
        };

        DateFormatHolder() {
        }

        public static SimpleDateFormat formatFor(String pattern) {
            SimpleDateFormat format;
            SoftReference<Map<String, SimpleDateFormat>> ref = THREADLOCAL_FORMATS.get();
            Map<String, SimpleDateFormat> formats = ref.get();
            if (formats == null) {
                formats = new HashMap<String, SimpleDateFormat>();
                THREADLOCAL_FORMATS.set(new SoftReference<Map<String, SimpleDateFormat>>(formats));
            }
            if ((format = formats.get(pattern)) == null) {
                format = new SimpleDateFormat(pattern, Locale.US);
                format.setTimeZone(TimeZone.getTimeZone("GMT"));
                formats.put(pattern, format);
            }
            return format;
        }

        public static void clearThreadLocal() {
            THREADLOCAL_FORMATS.remove();
        }
    }
}

