/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.httppart.bean;

import java.io.OutputStream;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Value;
import org.apache.juneau.annotation.InvalidAnnotationException;
import org.apache.juneau.http.annotation.Content;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.StatusCode;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.bean.ResponseBeanPropertyMeta;
import org.apache.juneau.httppart.bean.Utils;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.reflect.ParamInfo;

public class ResponseBeanMeta {
    public static ResponseBeanMeta NULL = new ResponseBeanMeta(new Builder(AnnotationWorkList.create()));
    private final ClassMeta<?> cm;
    private final Map<String, ResponseBeanPropertyMeta> properties;
    private final int code;
    private final Map<String, ResponseBeanPropertyMeta> headerMethods;
    private final ResponseBeanPropertyMeta statusMethod;
    private final ResponseBeanPropertyMeta contentMethod;
    private final Optional<HttpPartSerializer> partSerializer;
    private final Optional<HttpPartParser> partParser;
    private final HttpPartSchema schema;

    public static ResponseBeanMeta create(Type t, AnnotationWorkList annotations) {
        ClassInfo ci = ClassInfo.of(t).unwrap(Value.class, Optional.class);
        if (ci.hasNoAnnotation(Response.class)) {
            return null;
        }
        Builder b = new Builder(annotations);
        b.apply(ci.innerType());
        ci.forEachAnnotation(Response.class, x -> true, x -> b.apply((Response)x));
        ci.forEachAnnotation(StatusCode.class, x -> true, x -> b.apply((StatusCode)x));
        return b.build();
    }

    public static ResponseBeanMeta create(MethodInfo m, AnnotationWorkList annotations) {
        if (!m.hasAnnotation(Response.class) && !m.getReturnType().unwrap(Value.class, Optional.class).hasAnnotation(Response.class)) {
            return null;
        }
        Builder b = new Builder(annotations);
        b.apply(m.getReturnType().unwrap(Value.class, Optional.class).innerType());
        m.forEachAnnotation(Response.class, x -> true, x -> b.apply((Response)x));
        m.forEachAnnotation(StatusCode.class, x -> true, x -> b.apply((StatusCode)x));
        return b.build();
    }

    public static ResponseBeanMeta create(ParamInfo mpi, AnnotationWorkList annotations) {
        if (mpi.hasNoAnnotation(Response.class)) {
            return null;
        }
        Builder b = new Builder(annotations);
        b.apply(mpi.getParameterType().unwrap(Value.class, Optional.class).innerType());
        mpi.forEachAnnotation(Response.class, x -> true, x -> b.apply((Response)x));
        mpi.forEachAnnotation(StatusCode.class, x -> true, x -> b.apply((StatusCode)x));
        return b.build();
    }

    ResponseBeanMeta(Builder b) {
        this.cm = b.cm;
        this.code = b.code;
        this.partSerializer = CollectionUtils.optional(b.partSerializer).map(x -> (HttpPartSerializer)HttpPartSerializer.creator().type((Class)x).apply(b.annotations).create());
        this.partParser = CollectionUtils.optional(b.partParser).map(x -> (HttpPartParser)HttpPartParser.creator().type((Class)x).apply(b.annotations).create());
        this.schema = b.schema.build();
        LinkedHashMap<String, ResponseBeanPropertyMeta> properties = CollectionUtils.map();
        LinkedHashMap hm = CollectionUtils.map();
        b.headerMethods.forEach((k, v) -> {
            ResponseBeanPropertyMeta pm = v.build(this.partSerializer, this.partParser);
            hm.put(k, pm);
            properties.put(pm.getGetter().getName(), pm);
        });
        this.headerMethods = CollectionUtils.unmodifiable(hm);
        this.contentMethod = b.contentMethod == null ? null : b.contentMethod.schema(this.schema).build(this.partSerializer, this.partParser);
        ResponseBeanPropertyMeta responseBeanPropertyMeta = this.statusMethod = b.statusMethod == null ? null : b.statusMethod.build(CollectionUtils.empty(), CollectionUtils.empty());
        if (this.contentMethod != null) {
            properties.put(this.contentMethod.getGetter().getName(), this.contentMethod);
        }
        if (this.statusMethod != null) {
            properties.put(this.statusMethod.getGetter().getName(), this.statusMethod);
        }
        this.properties = CollectionUtils.unmodifiable(properties);
    }

    public int getCode() {
        return this.code;
    }

    public HttpPartSchema getSchema() {
        return this.schema;
    }

    public Collection<ResponseBeanPropertyMeta> getHeaderMethods() {
        return this.headerMethods.values();
    }

    public ResponseBeanPropertyMeta getContentMethod() {
        return this.contentMethod;
    }

    public ResponseBeanPropertyMeta getStatusMethod() {
        return this.statusMethod;
    }

    public Optional<HttpPartSerializer> getPartSerializer() {
        return this.partSerializer;
    }

    public ClassMeta<?> getClassMeta() {
        return this.cm;
    }

    public ResponseBeanPropertyMeta getProperty(String name) {
        return this.properties.get(name);
    }

    public Collection<ResponseBeanPropertyMeta> getProperties() {
        return this.properties.values();
    }

    static class Builder {
        ClassMeta<?> cm;
        int code;
        AnnotationWorkList annotations;
        Class<? extends HttpPartSerializer> partSerializer;
        Class<? extends HttpPartParser> partParser;
        HttpPartSchema.Builder schema = HttpPartSchema.create();
        Map<String, ResponseBeanPropertyMeta.Builder> headerMethods = CollectionUtils.map();
        ResponseBeanPropertyMeta.Builder contentMethod;
        ResponseBeanPropertyMeta.Builder statusMethod;

        Builder(AnnotationWorkList annotations) {
            this.annotations = annotations;
        }

        Builder apply(Type t) {
            Class<?> c = ClassUtils.toClass(t);
            this.cm = BeanContext.DEFAULT.getClassMeta(c);
            ClassInfo ci = this.cm.getInfo();
            ci.forEachPublicMethod(x -> true, x -> {
                InvalidAnnotationException.assertNoInvalidAnnotations(x, Query.class, FormData.class);
                if (x.hasAnnotation(Header.class)) {
                    Utils.assertNoArgs(x, Header.class);
                    Utils.assertReturnNotVoid(x, Header.class);
                    HttpPartSchema s = HttpPartSchema.create(x.getAnnotation(Header.class), x.getPropertyName());
                    this.headerMethods.put(s.getName(), ResponseBeanPropertyMeta.create(HttpPartType.RESPONSE_HEADER, s, x));
                } else if (x.hasAnnotation(StatusCode.class)) {
                    Utils.assertNoArgs(x, Header.class);
                    Utils.assertReturnType(x, Header.class, Integer.TYPE, Integer.class);
                    this.statusMethod = ResponseBeanPropertyMeta.create(HttpPartType.RESPONSE_STATUS, x);
                } else if (x.hasAnnotation(Content.class)) {
                    if (x.hasNoParams()) {
                        Utils.assertReturnNotVoid(x, Header.class);
                    } else {
                        Utils.assertArgType(x, Header.class, OutputStream.class, Writer.class);
                    }
                    this.contentMethod = ResponseBeanPropertyMeta.create(HttpPartType.RESPONSE_BODY, x);
                }
            });
            return this;
        }

        Builder apply(Response a) {
            if (a != null) {
                if (ClassUtils.isNotVoid(a.serializer())) {
                    this.partSerializer = a.serializer();
                }
                if (ClassUtils.isNotVoid(a.parser())) {
                    this.partParser = a.parser();
                }
                this.schema.apply((Annotation)a.schema());
            }
            return this;
        }

        Builder apply(StatusCode a) {
            if (a != null && a.value().length > 0) {
                this.code = a.value()[0];
            }
            return this;
        }

        ResponseBeanMeta build() {
            return new ResponseBeanMeta(this);
        }
    }
}

