/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.matcher;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class MethodOverrideMatcher<T extends MethodDescription>
extends ElementMatcher.Junction.AbstractBase<T> {
    private final ElementMatcher<? super TypeDescription.Generic> matcher;

    public MethodOverrideMatcher(ElementMatcher<? super TypeDescription.Generic> matcher) {
        this.matcher = matcher;
    }

    @Override
    public boolean matches(T target) {
        HashSet<TypeDescription> duplicates = new HashSet<TypeDescription>();
        for (TypeDefinition typeDefinition : target.getDeclaringType()) {
            if (!this.matches((MethodDescription)target, typeDefinition) && !this.matches((MethodDescription)target, typeDefinition.getInterfaces(), (Set<TypeDescription>)duplicates)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(MethodDescription target, List<? extends TypeDefinition> typeDefinitions, Set<TypeDescription> duplicates) {
        for (TypeDefinition typeDefinition : typeDefinitions) {
            if (!duplicates.add(typeDefinition.asErasure()) || !this.matches(target, typeDefinition) && !this.matches(target, typeDefinition.getInterfaces(), duplicates)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(MethodDescription target, TypeDefinition typeDefinition) {
        for (MethodDescription methodDescription : (MethodList)typeDefinition.getDeclaredMethods().filter(ElementMatchers.isVirtual())) {
            if (!methodDescription.asSignatureToken().equals(target.asSignatureToken())) continue;
            if (!this.matcher.matches(typeDefinition.asGenericType())) break;
            return true;
        }
        return false;
    }

    public String toString() {
        return "isOverriddenFrom(" + this.matcher + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodOverrideMatcher)) {
            return false;
        }
        MethodOverrideMatcher other = (MethodOverrideMatcher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ElementMatcher<? super TypeDescription.Generic> this$matcher = this.matcher;
        ElementMatcher<? super TypeDescription.Generic> other$matcher = other.matcher;
        return !(this$matcher == null ? other$matcher != null : !this$matcher.equals(other$matcher));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MethodOverrideMatcher;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ElementMatcher<? super TypeDescription.Generic> $matcher = this.matcher;
        result = result * 59 + ($matcher == null ? 43 : $matcher.hashCode());
        return result;
    }
}

