/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.schema.registries.synchronizers;

import java.util.ArrayList;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.exception.LdapSchemaViolationException;
import org.apache.directory.api.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.api.ldap.model.schema.registries.Schema;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.schema.registries.synchronizers.AbstractRegistrySynchronizer;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NormalizerSynchronizer
extends AbstractRegistrySynchronizer {
    private static final Logger LOG = LoggerFactory.getLogger(NormalizerSynchronizer.class);

    public NormalizerSynchronizer(SchemaManager schemaManager) throws Exception {
        super(schemaManager);
    }

    @Override
    public boolean modify(ModifyOperationContext modifyContext, Entry targetEntry, boolean cascade) throws LdapException {
        Dn name = modifyContext.getDn();
        Entry entry = modifyContext.getEntry();
        String schemaName = this.getSchemaName(name);
        String oldOid = this.getOid(entry);
        Normalizer normalizer = this.factory.getNormalizer(this.schemaManager, targetEntry, this.schemaManager.getRegistries(), schemaName);
        if (this.isSchemaEnabled(schemaName)) {
            normalizer.setSchemaName(schemaName);
            this.schemaManager.unregisterNormalizer(oldOid);
            this.schemaManager.add((SchemaObject)normalizer);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void add(Entry entry) throws LdapException {
        Dn dn = entry.getDn();
        Dn parentDn = dn.getParent();
        this.checkParent(parentDn, this.schemaManager, "Normalizer");
        this.checkOidIsUniqueForNormalizer(entry);
        String schemaName = this.getSchemaName(dn);
        Normalizer normalizer = this.factory.getNormalizer(this.schemaManager, entry, this.schemaManager.getRegistries(), schemaName);
        Schema schema = this.schemaManager.getLoadedSchema(schemaName);
        ArrayList errors = new ArrayList();
        if (schema.isEnabled() && normalizer.isEnabled()) {
            if (this.schemaManager.add((SchemaObject)normalizer)) {
                LOG.debug("Added {} into the enabled schema {}", (Object)dn.getName(), (Object)schemaName);
                return;
            }
            String msg = I18n.err((I18n)I18n.ERR_364, (Object[])new Object[]{entry.getDn().getName(), Strings.listToString(errors)});
            LOG.info(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        this.schemaManager.getRegistries().associateWithSchema((SchemaObject)normalizer);
        if (!errors.isEmpty()) {
            String msg = I18n.err((I18n)I18n.ERR_365, (Object[])new Object[]{entry.getDn().getName(), Strings.listToString(errors)});
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        LOG.debug("The normalizer {} cannot be added in schema {}", (Object)dn.getName(), (Object)schemaName);
    }

    @Override
    public void delete(Entry entry, boolean cascade) throws LdapException {
        Dn dn = entry.getDn();
        Dn parentDn = dn.getParent();
        this.checkParent(parentDn, this.schemaManager, "Normalizer");
        String schemaName = this.getSchemaName(entry.getDn());
        Normalizer normalizer = this.factory.getNormalizer(this.schemaManager, entry, this.schemaManager.getRegistries(), schemaName);
        String oid = normalizer.getOid();
        if (this.isSchemaEnabled(schemaName)) {
            if (this.schemaManager.getRegistries().isReferenced((SchemaObject)normalizer)) {
                String msg = I18n.err((I18n)I18n.ERR_366, (Object[])new Object[]{entry.getDn().getName(), this.getReferenced((SchemaObject)normalizer)});
                LOG.warn(msg);
                throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
            }
            this.deleteFromSchema((SchemaObject)normalizer, schemaName);
        }
        if (this.schemaManager.getNormalizerRegistry().contains(oid)) {
            this.schemaManager.unregisterNormalizer(oid);
            LOG.debug("Removed {} from the enabled schema {}", (Object)normalizer, (Object)schemaName);
        } else {
            LOG.debug("Removed {} from the enabled schema {}", (Object)normalizer, (Object)schemaName);
        }
    }

    @Override
    public void rename(Entry entry, Rdn newRdn, boolean cascade) throws LdapException {
        String oldOid = this.getOid(entry);
        String schemaName = this.getSchemaName(entry.getDn());
        if (this.schemaManager.getMatchingRuleRegistry().contains(oldOid)) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err((I18n)I18n.ERR_367, (Object[])new Object[]{oldOid}));
        }
        String newOid = newRdn.getValue();
        this.checkOidIsUniqueForNormalizer(newOid);
        if (this.isSchemaEnabled(schemaName)) {
            Entry targetEntry = entry.clone();
            targetEntry.put("m-oid", new String[]{newOid});
            Dn newDn = targetEntry.getDn().getParent();
            newDn = newDn.add(newRdn);
            targetEntry.setDn(newDn);
            Normalizer normalizer = this.factory.getNormalizer(this.schemaManager, targetEntry, this.schemaManager.getRegistries(), schemaName);
            this.schemaManager.unregisterNormalizer(oldOid);
            this.schemaManager.add((SchemaObject)normalizer);
        }
    }

    @Override
    public void moveAndRename(Dn oriChildName, Dn newParentName, Rdn newRdn, boolean deleteOldRn, Entry entry, boolean cascade) throws LdapException {
        this.checkNewParent(newParentName);
        String oldOid = this.getOid(entry);
        String oldSchemaName = this.getSchemaName(oriChildName);
        String newSchemaName = this.getSchemaName(newParentName);
        if (this.schemaManager.getMatchingRuleRegistry().contains(oldOid)) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err((I18n)I18n.ERR_367, (Object[])new Object[]{oldOid}));
        }
        String oid = newRdn.getValue();
        this.checkOidIsUniqueForNormalizer(oid);
        Normalizer normalizer = this.factory.getNormalizer(this.schemaManager, entry, this.schemaManager.getRegistries(), newSchemaName);
        if (this.isSchemaEnabled(oldSchemaName)) {
            this.schemaManager.unregisterNormalizer(oldOid);
        }
        if (this.isSchemaEnabled(newSchemaName)) {
            this.schemaManager.add((SchemaObject)normalizer);
        }
    }

    @Override
    public void move(Dn oriChildName, Dn newParentName, Entry entry, boolean cascade) throws LdapException {
        this.checkNewParent(newParentName);
        String oid = this.getOid(entry);
        String oldSchemaName = this.getSchemaName(oriChildName);
        String newSchemaName = this.getSchemaName(newParentName);
        if (this.schemaManager.getMatchingRuleRegistry().contains(oid)) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err((I18n)I18n.ERR_368, (Object[])new Object[]{oid}));
        }
        Normalizer normalizer = this.factory.getNormalizer(this.schemaManager, entry, this.schemaManager.getRegistries(), newSchemaName);
        if (this.isSchemaEnabled(oldSchemaName)) {
            this.schemaManager.unregisterNormalizer(oid);
        }
        if (this.isSchemaEnabled(newSchemaName)) {
            this.schemaManager.add((SchemaObject)normalizer);
        }
    }

    private void checkOidIsUniqueForNormalizer(String oid) throws LdapException {
        if (this.schemaManager.getNormalizerRegistry().contains(oid)) {
            throw new LdapSchemaViolationException(ResultCodeEnum.OTHER, I18n.err((I18n)I18n.ERR_369, (Object[])new Object[]{oid}));
        }
    }

    private void checkOidIsUniqueForNormalizer(Entry entry) throws LdapException {
        String oid = this.getOid(entry);
        if (this.schemaManager.getNormalizerRegistry().contains(oid)) {
            throw new LdapSchemaViolationException(ResultCodeEnum.OTHER, I18n.err((I18n)I18n.ERR_369, (Object[])new Object[]{oid}));
        }
    }

    private void checkNewParent(Dn newParent) throws LdapException {
        if (newParent.size() != 3) {
            throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, I18n.err((I18n)I18n.ERR_370, (Object[])new Object[0]));
        }
        Rdn rdn = newParent.getRdn();
        if (!this.schemaManager.getAttributeTypeRegistry().getOidByName(rdn.getNormType()).equals("2.5.4.11")) {
            throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, I18n.err((I18n)I18n.ERR_371, (Object[])new Object[0]));
        }
        if (!rdn.getValue().equalsIgnoreCase("normalizers")) {
            throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, I18n.err((I18n)I18n.ERR_372, (Object[])new Object[0]));
        }
    }
}

