/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.spark;

import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.model.AbstractServiceModelGenerator;

public class SparkHistoryUIServiceModelGenerator
extends AbstractServiceModelGenerator {
    private static final String SERVICE = "SPARKHISTORYUI";
    private static final String SERVICE_TYPE = "SPARK_ON_YARN";
    private static final String ROLE_TYPE = "SPARK_YARN_HISTORY_SERVER";

    @Override
    public boolean handles(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) {
        return SERVICE_TYPE.equals(service.getType()) && ROLE_TYPE.equals(role.getType());
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) {
        String port;
        String scheme;
        String hostname = role.getHostRef().getHostname();
        boolean sslEnabled = Boolean.parseBoolean(this.getRoleConfigValue(roleConfig, "ssl_enabled"));
        if (sslEnabled) {
            scheme = "https";
            port = this.getRoleConfigValue(roleConfig, "ssl_server_port");
        } else {
            scheme = "http";
            port = this.getRoleConfigValue(roleConfig, "history_server_web_port");
        }
        return new ServiceModel(ServiceModel.Type.UI, SERVICE, String.format(Locale.getDefault(), "%s://%s:%s", scheme, hostname, port));
    }
}

