/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.normalizers;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapOtherException;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.ldap.model.schema.PrepareString;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.syntaxCheckers.NumericOidSyntaxChecker;
import org.apache.directory.api.util.Strings;

public class NameOrNumericIdNormalizer
extends Normalizer {
    private NumericOidSyntaxChecker checker = NumericOidSyntaxChecker.INSTANCE;
    private transient SchemaManager schemaManager;
    public static final NameOrNumericIdNormalizer INSTANCE = new NameOrNumericIdNormalizer();

    public NameOrNumericIdNormalizer() {
        super("1.3.6.1.4.1.18060.0.4.0.1.0");
    }

    @Override
    public String normalize(String value) throws LdapException {
        return this.normalize(value, PrepareString.AssertionType.ATTRIBUTE_VALUE);
    }

    @Override
    public String normalize(String value, PrepareString.AssertionType assertionType) throws LdapException {
        if (Strings.isEmpty((String)value)) {
            return value;
        }
        if (this.checker.isValidSyntax(value)) {
            return value;
        }
        String oid = this.schemaManager.getRegistries().getOid(value);
        if (oid != null) {
            return oid;
        }
        throw new LdapOtherException(I18n.err((I18n)I18n.ERR_13725_CANNOT_HANDLE_NAME_AND_OPTIONAL_UID_NORM, (Object[])new Object[]{value}));
    }

    @Override
    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }
}

