/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.cli;

import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.Credential;
import org.ldaptive.LdapEntry;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.SearchResult;
import org.ldaptive.auth.AuthenticationRequest;
import org.ldaptive.auth.AuthenticationResponse;
import org.ldaptive.auth.Authenticator;
import org.ldaptive.auth.SearchDnResolver;
import org.ldaptive.cli.AbstractCli;
import org.ldaptive.io.Dsmlv1Writer;
import org.ldaptive.io.LdifWriter;
import org.ldaptive.io.SearchResultWriter;
import org.ldaptive.props.AuthenticationRequestPropertySource;
import org.ldaptive.props.AuthenticatorPropertySource;
import org.ldaptive.props.BindConnectionInitializerPropertySource;
import org.ldaptive.props.ConnectionConfigPropertySource;
import org.ldaptive.props.PropertySource;
import org.ldaptive.props.SearchDnResolverPropertySource;

public class AuthenticatorCli
extends AbstractCli {
    private static final String OPT_DSMLV1 = "dsmlv1";
    private static final String COMMAND_NAME = "ldapauth";

    public static void main(String[] args) {
        AuthenticatorCli cli = new AuthenticatorCli();
        int status = cli.performAction(args);
        System.exit(status);
    }

    @Override
    protected void initOptions() {
        this.options.addOption(new Option(OPT_DSMLV1, false, "output results in DSML v1"));
        Map<String, String> desc = this.getArgDesc(ConnectionConfig.class, Authenticator.class, SearchDnResolver.class, AuthenticationRequest.class);
        for (String s : ConnectionConfigPropertySource.getProperties()) {
            this.options.addOption(new Option(s, true, desc.get(s)));
        }
        for (String s : BindConnectionInitializerPropertySource.getProperties()) {
            this.options.addOption(new Option(s, true, desc.get(s)));
        }
        for (String s : AuthenticatorPropertySource.getProperties()) {
            this.options.addOption(new Option(s, true, desc.get(s)));
        }
        for (String s : SearchDnResolverPropertySource.getProperties()) {
            if (s.startsWith("search")) continue;
            this.options.addOption(new Option(s, true, desc.get(s)));
        }
        for (String s : AuthenticationRequestPropertySource.getProperties()) {
            this.options.addOption(new Option(s, true, desc.get(s)));
        }
        super.initOptions();
    }

    protected Authenticator initAuthenticator(CommandLine line) {
        Authenticator auth = new Authenticator();
        AuthenticatorPropertySource aSource = new AuthenticatorPropertySource(auth, this.getPropertiesFromOptions(PropertySource.PropertyDomain.AUTH.value(), line));
        aSource.initialize();
        return auth;
    }

    protected AuthenticationRequest initAuthenticationRequest(CommandLine line) {
        AuthenticationRequest request = new AuthenticationRequest();
        AuthenticationRequestPropertySource arSource = new AuthenticationRequestPropertySource(request, this.getPropertiesFromOptions(PropertySource.PropertyDomain.AUTH.value(), line));
        arSource.initialize();
        if (request.getUser() == null) {
            String user = System.console().readLine("[Enter user name]: ", new Object[0]);
            request.setUser(user);
        }
        if (request.getCredential() == null) {
            char[] pass = System.console().readPassword("[Enter password for %s]: ", request.getUser());
            request.setCredential(new Credential(pass));
        }
        return request;
    }

    @Override
    protected int dispatch(CommandLine line) throws Exception {
        if (line.hasOption(OPT_DSMLV1)) {
            this.outputDsmlv1 = true;
        }
        if (!line.hasOption("help")) {
            return this.authenticate(this.initAuthenticator(line), this.initAuthenticationRequest(line));
        }
        this.printHelp();
        return -1;
    }

    protected int authenticate(Authenticator auth, AuthenticationRequest request) throws Exception {
        if (request.getReturnAttributes() != null && request.getReturnAttributes().length == 0) {
            request.setReturnAttributes(ReturnAttributes.ALL_USER.value());
        }
        AuthenticationResponse response = auth.authenticate(request);
        LdapEntry entry = response.getLdapEntry();
        if (((Boolean)response.getResult()).booleanValue()) {
            if (entry != null) {
                SearchResultWriter writer = this.outputDsmlv1 ? new Dsmlv1Writer(new BufferedWriter(new OutputStreamWriter(System.out))) : new LdifWriter(new BufferedWriter(new OutputStreamWriter(System.out)));
                writer.write(new SearchResult(entry));
            }
        } else {
            System.out.println(String.format("Authentication failed for %s", entry));
        }
        return response.getResultCode().value();
    }

    @Override
    protected String getCommandName() {
        return COMMAND_NAME;
    }
}

