/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.plang;

import java.util.ArrayList;
import java.util.List;
import org.apache.knox.gateway.plang.InterpreterException;

public class AbstractSyntaxTree {
    private final List<AbstractSyntaxTree> children = new ArrayList<AbstractSyntaxTree>();
    private final String token;

    public AbstractSyntaxTree(String token) {
        this.token = token;
    }

    public void addChild(AbstractSyntaxTree child) {
        this.children.add(child);
    }

    public String toString() {
        return this.isAtom() ? this.token : this.children.toString();
    }

    public String token() {
        return this.token;
    }

    public boolean isStr() {
        return this.token != null && this.token.startsWith("'") && this.token.endsWith("'");
    }

    public boolean isNumber() {
        boolean result = false;
        if (this.token != null) {
            try {
                this.numValue();
                result = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public Number numValue() {
        try {
            return Long.parseLong(this.token);
        }
        catch (NumberFormatException e) {
            return Double.parseDouble(this.token);
        }
    }

    public String strValue() {
        if (!this.isStr()) {
            throw new InterpreterException("Token: " + this.token + " is not a String");
        }
        return this.token.substring(1, this.token.length() - 1);
    }

    public boolean isAtom() {
        return !"(".equals(this.token);
    }

    public boolean isFunction() {
        return !this.children.isEmpty();
    }

    public String functionName() {
        return this.children.get(0).token();
    }

    public List<AbstractSyntaxTree> functionParameters() {
        return this.children.subList(1, this.children.size());
    }
}

