/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.mavibot;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Comparator;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.EmptyCursor;
import org.apache.directory.api.ldap.model.cursor.Tuple;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapOtherException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.comparators.SerializableComparator;
import org.apache.directory.mavibot.btree.RecordManager;
import org.apache.directory.mavibot.btree.serializer.ByteArraySerializer;
import org.apache.directory.mavibot.btree.serializer.StringSerializer;
import org.apache.directory.server.core.api.partition.PartitionTxn;
import org.apache.directory.server.core.partition.impl.btree.IndexCursorAdaptor;
import org.apache.directory.server.core.partition.impl.btree.mavibot.MavibotTable;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndex;
import org.apache.directory.server.xdbm.IndexEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavibotIndex<K>
extends AbstractIndex<K, String> {
    private static final Logger LOG = LoggerFactory.getLogger((String)MavibotIndex.class.getSimpleName());
    public static final String FORWARD_BTREE = "_forward";
    public static final String REVERSE_BTREE = "_reverse";
    protected MavibotTable<K, String> forward;
    protected MavibotTable<String, K> reverse;
    protected File wkDirPath;
    protected RecordManager recordMan;

    public MavibotIndex(String attributeId, boolean withReverse) {
        super(attributeId, withReverse);
        this.initialized = false;
    }

    public void init(SchemaManager schemaManager, AttributeType attributeType) throws LdapException, IOException {
        LOG.debug("Initializing an Index for attribute '{}'", (Object)attributeType.getName());
        if (this.recordMan == null) {
            throw new IllegalStateException("No RecordManager reference was set in the index " + this.getAttributeId());
        }
        this.attributeType = attributeType;
        if (this.attributeId == null) {
            this.setAttributeId(attributeType.getName());
        }
        if (this.wkDirPath == null) {
            throw new NullPointerException("The index working directory has not be set");
        }
        try {
            this.initTables(schemaManager);
        }
        catch (IOException e) {
            this.close(null);
            throw e;
        }
        this.initialized = true;
    }

    private void initTables(SchemaManager schemaManager) throws IOException {
        MatchingRule mr = this.attributeType.getEquality();
        if (mr == null) {
            throw new IOException(I18n.err((I18n)I18n.ERR_574, (Object[])new Object[]{this.attributeType.getName()}));
        }
        SerializableComparator comp = new SerializableComparator(mr.getOid());
        comp.setSchemaManager(schemaManager);
        Object forwardKeySerializer = null;
        forwardKeySerializer = !this.attributeType.getSyntax().isHumanReadable() ? new ByteArraySerializer((Comparator)comp) : new StringSerializer((Comparator)comp);
        boolean forwardDups = true;
        String oid = this.attributeType.getOid();
        if (oid.equals("1.3.6.1.4.1.4203.666.1.7") || oid.equals("1.3.6.1.1.16.4")) {
            forwardDups = false;
        }
        String forwardTableName = this.attributeType.getOid() + FORWARD_BTREE;
        this.forward = new MavibotTable(this.recordMan, schemaManager, forwardTableName, forwardKeySerializer, StringSerializer.INSTANCE, forwardDups, 10000);
        if (this.withReverse) {
            String reverseTableName = this.attributeType.getOid() + REVERSE_BTREE;
            this.reverse = new MavibotTable(this.recordMan, schemaManager, reverseTableName, StringSerializer.INSTANCE, forwardKeySerializer, !this.attributeType.isSingleValued());
        }
    }

    public void setRecordManager(RecordManager rm) {
        this.recordMan = rm;
    }

    public void setWkDirPath(URI wkDirPath) {
        this.protect("wkDirPath");
        this.wkDirPath = new File(wkDirPath);
    }

    public URI getWkDirPath() {
        return this.wkDirPath != null ? this.wkDirPath.toURI() : null;
    }

    public long count(PartitionTxn partitionTxn) throws LdapException {
        return this.forward.count(partitionTxn);
    }

    public long count(PartitionTxn partitionTxn, K attrVal) throws LdapException {
        return this.forward.count(partitionTxn, attrVal);
    }

    public long greaterThanCount(PartitionTxn partitionTxn, K attrVal) throws LdapException {
        return this.forward.greaterThanCount(partitionTxn, attrVal);
    }

    public long lessThanCount(PartitionTxn partitionTxn, K attrVal) throws LdapException {
        return this.forward.lessThanCount(partitionTxn, attrVal);
    }

    public String forwardLookup(PartitionTxn partitionTxn, K attrVal) throws LdapException {
        return this.forward.get(partitionTxn, attrVal);
    }

    public K reverseLookup(PartitionTxn partitionTxn, String id) throws LdapException {
        if (this.withReverse) {
            return this.reverse.get(partitionTxn, id);
        }
        return null;
    }

    public synchronized void add(PartitionTxn partitionTxn, K attrVal, String id) throws LdapException {
        this.forward.put(partitionTxn, attrVal, id);
        if (this.withReverse) {
            this.reverse.put(partitionTxn, id, (String)attrVal);
        }
    }

    public synchronized void drop(PartitionTxn partitionTxn, K attrVal, String id) throws LdapException {
        if (this.forward.has(partitionTxn, attrVal, id)) {
            this.forward.remove(partitionTxn, attrVal, id);
            if (this.withReverse) {
                this.reverse.remove(partitionTxn, id, (String)attrVal);
            }
        }
    }

    public void drop(PartitionTxn partitionTxn, String entryId) throws LdapException {
        if (this.withReverse) {
            if (this.isDupsEnabled()) {
                Cursor<Tuple<String, K>> values = this.reverse.cursor(partitionTxn, entryId);
                try {
                    while (values.next()) {
                        this.forward.remove(partitionTxn, ((Tuple)values.get()).getValue(), entryId);
                    }
                    values.close();
                }
                catch (IOException | CursorException e) {
                    throw new LdapOtherException(e.getMessage(), e);
                }
            } else {
                K key = this.reverse.get(partitionTxn, entryId);
                this.forward.remove(partitionTxn, key);
            }
            this.reverse.remove(partitionTxn, entryId);
        }
    }

    public Cursor<IndexEntry<K, String>> forwardCursor(PartitionTxn partitionTxn) throws LdapException {
        return new IndexCursorAdaptor(partitionTxn, this.forward.cursor(), true);
    }

    public Cursor<IndexEntry<K, String>> forwardCursor(PartitionTxn partitionTxn, K key) throws LdapException {
        return new IndexCursorAdaptor(partitionTxn, this.forward.cursor(partitionTxn, key), true);
    }

    public Cursor<K> reverseValueCursor(PartitionTxn partitionTxn, String id) throws LdapException {
        if (this.withReverse) {
            return this.reverse.valueCursor(partitionTxn, id);
        }
        return new EmptyCursor();
    }

    public Cursor<String> forwardValueCursor(PartitionTxn partitionTxn, K key) throws LdapException {
        return this.forward.valueCursor(partitionTxn, key);
    }

    public boolean forward(PartitionTxn partitionTxn, K attrVal) throws LdapException {
        return this.forward.has(partitionTxn, attrVal);
    }

    public boolean forward(PartitionTxn partitionTxn, K attrVal, String id) throws LdapException {
        return this.forward.has(partitionTxn, attrVal, id);
    }

    public boolean reverse(PartitionTxn partitionTxn, String id) throws LdapException {
        if (this.withReverse) {
            return this.reverse.has(partitionTxn, id);
        }
        return false;
    }

    public boolean reverse(PartitionTxn partitionTxn, String id, K attrVal) throws LdapException {
        return this.forward.has(partitionTxn, attrVal, id);
    }

    public synchronized void close(PartitionTxn partitionTxn) throws IOException {
        try {
            if (this.forward != null) {
                this.forward.close(partitionTxn);
            }
            if (this.reverse != null) {
                this.reverse.close(partitionTxn);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public synchronized void sync() throws IOException {
        this.forward.getBTree().flush();
        if (this.reverse != null) {
            this.reverse.getBTree().flush();
        }
    }

    public boolean isDupsEnabled() {
        if (this.withReverse) {
            return this.reverse.isDupsEnabled();
        }
        return false;
    }

    public String toString() {
        return "Index<" + this.attributeId + ">";
    }
}

