/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.factory;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.Service;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.factory.AbstractServiceFactory;
import org.apache.knox.gateway.session.control.EmptyConcurrentSessionVerifier;
import org.apache.knox.gateway.session.control.InMemoryConcurrentSessionVerifier;

public class ConcurrentSessionVerifierFactory
extends AbstractServiceFactory {
    private static final GatewayMessages LOG = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);

    @Override
    protected Service createService(GatewayServices gatewayServices, ServiceType serviceType, GatewayConfig gatewayConfig, Map<String, String> options, String implementation) throws ServiceLifecycleException {
        Object service = null;
        if (this.shouldCreateService(implementation)) {
            if (this.matchesImplementation(implementation, EmptyConcurrentSessionVerifier.class, true)) {
                service = new EmptyConcurrentSessionVerifier();
            } else if (this.matchesImplementation(implementation, InMemoryConcurrentSessionVerifier.class)) {
                service = new InMemoryConcurrentSessionVerifier();
                if (gatewayConfig.getSessionVerificationPrivilegedUsers().isEmpty()) {
                    LOG.privilegedUserGroupIsNotConfigured();
                }
            }
            this.logServiceUsage(implementation, serviceType);
        }
        return service;
    }

    @Override
    protected ServiceType getServiceType() {
        return ServiceType.CONCURRENT_SESSION_VERIFIER;
    }

    @Override
    protected Collection<String> getKnownImplementations() {
        return Collections.unmodifiableList(Arrays.asList(InMemoryConcurrentSessionVerifier.class.getName(), EmptyConcurrentSessionVerifier.class.getName()));
    }
}

