/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.config.event;

import org.apache.shiro.config.event.BeanEvent;
import org.apache.shiro.event.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingBeanEventListener {
    private static final Logger logger = LoggerFactory.getLogger(LoggingBeanEventListener.class);
    private static final String SUFFIX = BeanEvent.class.getSimpleName();

    @Subscribe
    public void onEvent(BeanEvent e) {
        String className = ((Object)((Object)e)).getClass().getSimpleName();
        int i = className.lastIndexOf(SUFFIX);
        String subclassPrefix = i > 0 ? className.substring(0, i) : className;
        logger.trace("{} bean '{}' [{}]", new Object[]{subclassPrefix, e.getBeanName(), e.getBean()});
    }
}

