/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.ldaptive.LdapException;
import org.ldaptive.auth.AuthenticationCriteria;
import org.ldaptive.auth.AuthenticationHandlerResponse;
import org.ldaptive.auth.DnResolver;
import org.ldaptive.auth.DnResolverEx;
import org.ldaptive.auth.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateDnResolver
implements DnResolver,
DnResolverEx {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ExecutorService service;
    private Map<String, DnResolver> dnResolvers;
    private boolean allowMultipleDns;

    public AggregateDnResolver() {
        this.service = Executors.newCachedThreadPool();
    }

    public AggregateDnResolver(Map<String, DnResolver> resolvers) {
        this(resolvers, Executors.newCachedThreadPool());
    }

    public AggregateDnResolver(Map<String, DnResolver> resolvers, ExecutorService es) {
        this.setDnResolvers(resolvers);
        this.service = es;
    }

    public Map<String, DnResolver> getDnResolvers() {
        return Collections.unmodifiableMap(this.dnResolvers);
    }

    public void setDnResolvers(Map<String, DnResolver> resolvers) {
        this.logger.trace("setting dnResolvers: {}", resolvers);
        this.dnResolvers = resolvers;
    }

    public boolean getAllowMultipleDns() {
        return this.allowMultipleDns;
    }

    public void setAllowMultipleDns(boolean b) {
        this.logger.trace("setting allowMultipleDns: {}", (Object)b);
        this.allowMultipleDns = b;
    }

    @Override
    public String resolve(String user) throws LdapException {
        return this.resolve(new User(user));
    }

    @Override
    public String resolve(final User user) throws LdapException {
        ExecutorCompletionService<String> cs = new ExecutorCompletionService<String>(this.service);
        ArrayList<String> results = new ArrayList<String>(this.dnResolvers.size());
        for (final Map.Entry<String, DnResolver> entry : this.dnResolvers.entrySet()) {
            cs.submit(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    String dn = entry.getValue() instanceof DnResolverEx ? ((DnResolverEx)entry.getValue()).resolve(user) : ((DnResolver)entry.getValue()).resolve(user.getIdentifier());
                    AggregateDnResolver.this.logger.debug("DN resolver {} resolved dn {} for user {}", new Object[]{entry.getValue(), dn, user});
                    if (dn != null && !dn.isEmpty()) {
                        return String.format("%s:%s", entry.getKey(), dn);
                    }
                    return null;
                }
            });
            this.logger.debug("submitted DN resolver {}", (Object)entry.getValue());
        }
        for (int i = 1; i <= this.dnResolvers.size(); ++i) {
            try {
                this.logger.trace("waiting on DN resolver {} of {}", (Object)i, (Object)this.dnResolvers.size());
                String dn = (String)cs.take().get();
                if (dn == null) continue;
                results.add(dn);
                continue;
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof LdapException) {
                    throw (LdapException)e.getCause();
                }
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                this.logger.warn("ExecutionException thrown, ignoring", (Throwable)e);
                continue;
            }
            catch (InterruptedException e) {
                this.logger.warn("InterruptedException thrown, ignoring", (Throwable)e);
            }
        }
        if (results.size() > 1 && !this.allowMultipleDns) {
            throw new LdapException("Found more than (1) DN for: " + user);
        }
        this.logger.debug("resolved aggregate DN {}", results);
        return results.isEmpty() ? null : (String)results.get(0);
    }

    public void shutdown() {
        this.service.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.shutdown();
        }
        finally {
            super.finalize();
        }
    }

    public static class AuthenticationHandler
    implements org.ldaptive.auth.AuthenticationHandler {
        protected final Logger logger = LoggerFactory.getLogger(this.getClass());
        private Map<String, org.ldaptive.auth.AuthenticationHandler> authenticationHandlers;

        public AuthenticationHandler() {
        }

        public AuthenticationHandler(Map<String, org.ldaptive.auth.AuthenticationHandler> handlers) {
            this.setAuthenticationHandlers(handlers);
        }

        public Map<String, org.ldaptive.auth.AuthenticationHandler> getAuthenticationHandlers() {
            return Collections.unmodifiableMap(this.authenticationHandlers);
        }

        public void setAuthenticationHandlers(Map<String, org.ldaptive.auth.AuthenticationHandler> handlers) {
            this.logger.trace("setting authenticationHandlers: {}", handlers);
            this.authenticationHandlers = handlers;
        }

        @Override
        public AuthenticationHandlerResponse authenticate(AuthenticationCriteria criteria) throws LdapException {
            String[] labeledDn = criteria.getDn().split(":", 2);
            org.ldaptive.auth.AuthenticationHandler ah = this.authenticationHandlers.get(labeledDn[0]);
            if (ah == null) {
                throw new LdapException("Could not find authentication handler for label: " + labeledDn[0]);
            }
            criteria.setDn(labeledDn[1]);
            return ah.authenticate(criteria);
        }
    }
}

