/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.ha.dispatch;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.knox.gateway.config.Configure;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.dispatch.ConfigurableDispatch;
import org.apache.knox.gateway.ha.config.CommonHaConfigurations;
import org.apache.knox.gateway.ha.config.HaConfigurations;
import org.apache.knox.gateway.ha.dispatch.CommonHaDispatch;
import org.apache.knox.gateway.ha.dispatch.i18n.HaDispatchMessages;
import org.apache.knox.gateway.ha.provider.HaProvider;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.util.HttpUtils;

public class ConfigurableHADispatch
extends ConfigurableDispatch
implements CommonHaDispatch {
    protected static final HaDispatchMessages LOG = (HaDispatchMessages)MessagesFactory.get(HaDispatchMessages.class);
    private final HaConfigurations haConfigurations = new CommonHaConfigurations();
    private final AtomicReference<String> activeURL = new AtomicReference();

    public void init() {
        super.init();
        LOG.initializingForResourceRole(this.getServiceRole());
        if (this.haConfigurations.getHaProvider() != null) {
            this.initializeCommonHaDispatch(this.haConfigurations.getHaProvider().getHaDescriptor().getServiceConfig(this.getServiceRole()));
        }
    }

    @Override
    public HaConfigurations getHaConfigurations() {
        return this.haConfigurations;
    }

    @Configure
    public void setHaProvider(HaProvider haProvider) {
        this.getHaConfigurations().setHaProvider(haProvider);
    }

    @Override
    public AtomicReference<String> getActiveURL() {
        return this.activeURL;
    }

    @Override
    public void setActiveURL(String url) {
        this.activeURL.set(url);
    }

    protected void executeRequestWrapper(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse) throws IOException {
        boolean userAgentDisabled = this.isUserAgentDisabled(inboundRequest);
        Optional backendURI = this.setBackendUri(outboundRequest, inboundRequest, userAgentDisabled);
        this.executeRequest(outboundRequest, inboundRequest, outboundResponse);
        this.shiftActiveURL(userAgentDisabled, backendURI);
    }

    protected void outboundResponseWrapper(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse) {
        GatewayConfig config = (GatewayConfig)inboundRequest.getServletContext().getAttribute("org.apache.knox.gateway.config");
        boolean sslEnabled = config != null && config.isSSLEnabled();
        this.setKnoxHaCookie(outboundRequest, inboundRequest, outboundResponse, sslEnabled);
    }

    protected void executeRequest(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse) throws IOException {
        HttpResponse inboundResponse = null;
        try {
            inboundResponse = this.executeOutboundRequest(outboundRequest);
            this.writeOutboundResponse(outboundRequest, inboundRequest, outboundResponse, inboundResponse);
        }
        catch (IOException e) {
            if (!HttpUtils.isConnectionError((Throwable)e.getCause()) && this.isNonIdempotentAndNonIdempotentFailoverDisabled(outboundRequest)) {
                LOG.cannotFailoverNonIdempotentRequest(outboundRequest.getMethod(), e.getCause());
                this.markEndpointFailed(outboundRequest, inboundRequest);
                throw e;
            }
            LOG.errorConnectingToServer(outboundRequest.getURI().toString(), e);
            this.failoverRequest(outboundRequest, inboundRequest, outboundResponse, inboundResponse, e);
        }
    }

    protected void failoverRequest(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse, HttpResponse inboundResponse, Exception exception) throws IOException {
        if (this.disabledFailoverHandled(inboundRequest, outboundResponse)) {
            return;
        }
        AtomicInteger counter = this.markEndpointFailed(outboundRequest, inboundRequest);
        inboundRequest.setAttribute("dispatch.ha.failover.counter", (Object)counter);
        if (counter.get() <= this.haConfigurations.getMaxFailoverAttempts()) {
            inboundRequest = this.prepareForFailover(outboundRequest, inboundRequest);
            this.executeRequest(outboundRequest, inboundRequest, outboundResponse);
        } else {
            LOG.maxFailoverAttemptsReached(this.haConfigurations.getMaxFailoverAttempts(), this.getServiceRole());
            if (inboundResponse != null) {
                this.writeOutboundResponse(outboundRequest, inboundRequest, outboundResponse, inboundResponse);
            } else {
                throw new IOException(exception);
            }
        }
    }
}

