/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ApiAddSBNNToNSArguments {
    @SerializedName(value="nameServiceName")
    private String nameServiceName = null;
    @SerializedName(value="newNNHostIds")
    private List<String> newNNHostIds = null;
    @SerializedName(value="newNNDataDirs")
    private Map<String, String> newNNDataDirs = null;
    @SerializedName(value="clearDataDirs")
    private Boolean clearDataDirs = null;
    @SerializedName(value="restartCluster")
    private Boolean restartCluster = null;

    public ApiAddSBNNToNSArguments nameServiceName(String nameServiceName) {
        this.nameServiceName = nameServiceName;
        return this;
    }

    @Schema(description="The name of the NameService to which the new NameNode(s) should be added.")
    public String getNameServiceName() {
        return this.nameServiceName;
    }

    public void setNameServiceName(String nameServiceName) {
        this.nameServiceName = nameServiceName;
    }

    public ApiAddSBNNToNSArguments newNNHostIds(List<String> newNNHostIds) {
        this.newNNHostIds = newNNHostIds;
        return this;
    }

    public ApiAddSBNNToNSArguments addNewNNHostIdsItem(String newNNHostIdsItem) {
        if (this.newNNHostIds == null) {
            this.newNNHostIds = new ArrayList<String>();
        }
        this.newNNHostIds.add(newNNHostIdsItem);
        return this;
    }

    @Schema(description="List of host ids to which new NameNode(s) should be added.")
    public List<String> getNewNNHostIds() {
        return this.newNNHostIds;
    }

    public void setNewNNHostIds(List<String> newNNHostIds) {
        this.newNNHostIds = newNNHostIds;
    }

    public ApiAddSBNNToNSArguments newNNDataDirs(Map<String, String> newNNDataDirs) {
        this.newNNDataDirs = newNNDataDirs;
        return this;
    }

    public ApiAddSBNNToNSArguments putNewNNDataDirsItem(String key, String newNNDataDirsItem) {
        if (this.newNNDataDirs == null) {
            this.newNNDataDirs = new HashMap<String, String>();
        }
        this.newNNDataDirs.put(key, newNNDataDirsItem);
        return this;
    }

    @Schema(description="Mapping of NameNode Data Directories list to host id(s), key is the host id, the value is a comma separated list of directories to be set as NameNode Data Directories for the new NameNode(s).")
    public Map<String, String> getNewNNDataDirs() {
        return this.newNNDataDirs;
    }

    public void setNewNNDataDirs(Map<String, String> newNNDataDirs) {
        this.newNNDataDirs = newNNDataDirs;
    }

    public ApiAddSBNNToNSArguments clearDataDirs(Boolean clearDataDirs) {
        this.clearDataDirs = clearDataDirs;
        return this;
    }

    @Schema(description="Specifies whether the NameNode Data Directories configured should be cleared as a first step, or the command should fail if the directories specified are not empty.")
    public Boolean isClearDataDirs() {
        return this.clearDataDirs;
    }

    public void setClearDataDirs(Boolean clearDataDirs) {
        this.clearDataDirs = clearDataDirs;
    }

    public ApiAddSBNNToNSArguments restartCluster(Boolean restartCluster) {
        this.restartCluster = restartCluster;
        return this;
    }

    @Schema(description="Specifies whether the HDFS dependent services of the cluster should be restarted after the changes are applied, to reconfigure dependent services")
    public Boolean isRestartCluster() {
        return this.restartCluster;
    }

    public void setRestartCluster(Boolean restartCluster) {
        this.restartCluster = restartCluster;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiAddSBNNToNSArguments apiAddSBNNToNSArguments = (ApiAddSBNNToNSArguments)o;
        return Objects.equals(this.nameServiceName, apiAddSBNNToNSArguments.nameServiceName) && Objects.equals(this.newNNHostIds, apiAddSBNNToNSArguments.newNNHostIds) && Objects.equals(this.newNNDataDirs, apiAddSBNNToNSArguments.newNNDataDirs) && Objects.equals(this.clearDataDirs, apiAddSBNNToNSArguments.clearDataDirs) && Objects.equals(this.restartCluster, apiAddSBNNToNSArguments.restartCluster);
    }

    public int hashCode() {
        return Objects.hash(this.nameServiceName, this.newNNHostIds, this.newNNDataDirs, this.clearDataDirs, this.restartCluster);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiAddSBNNToNSArguments {\n");
        sb.append("    nameServiceName: ").append(this.toIndentedString(this.nameServiceName)).append("\n");
        sb.append("    newNNHostIds: ").append(this.toIndentedString(this.newNNHostIds)).append("\n");
        sb.append("    newNNDataDirs: ").append(this.toIndentedString(this.newNNDataDirs)).append("\n");
        sb.append("    clearDataDirs: ").append(this.toIndentedString(this.clearDataDirs)).append("\n");
        sb.append("    restartCluster: ").append(this.toIndentedString(this.restartCluster)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

