/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.common;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.Principal;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.kylin.engine.mr.common.DefaultX509TrustManager;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.kylin.tool.shaded.org.apache.commons.io.IOUtils;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils;
import org.apache.kylin.tool.shaded.org.apache.commons.lang3.tuple.Pair;
import org.apache.kylin.tool.shaded.org.apache.http.Header;
import org.apache.kylin.tool.shaded.org.apache.http.HttpResponse;
import org.apache.kylin.tool.shaded.org.apache.http.auth.AuthSchemeRegistry;
import org.apache.kylin.tool.shaded.org.apache.http.auth.AuthScope;
import org.apache.kylin.tool.shaded.org.apache.http.auth.Credentials;
import org.apache.kylin.tool.shaded.org.apache.http.client.HttpClient;
import org.apache.kylin.tool.shaded.org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.kylin.tool.shaded.org.apache.http.client.methods.HttpGet;
import org.apache.kylin.tool.shaded.org.apache.http.conn.ClientConnectionManager;
import org.apache.kylin.tool.shaded.org.apache.http.conn.scheme.Scheme;
import org.apache.kylin.tool.shaded.org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.kylin.tool.shaded.org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.kylin.tool.shaded.org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.kylin.tool.shaded.org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.kylin.tool.shaded.org.apache.http.impl.client.DefaultHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopStatusGetter {
    private final String mrJobId;
    private final String yarnUrl;
    protected static final Logger logger = LoggerFactory.getLogger(HadoopStatusGetter.class);
    private static String DEFAULT_KRB5_CONFIG_LOCATION = "/etc/krb5.conf";

    public HadoopStatusGetter(String yarnUrl, String mrJobId) {
        this.yarnUrl = yarnUrl;
        this.mrJobId = mrJobId;
    }

    public Pair<RMAppState, FinalApplicationStatus> get(boolean useKerberosAuth) throws IOException {
        String applicationId = this.mrJobId.replace("job", "application");
        String url = this.yarnUrl.replace("${job_id}", applicationId);
        String response = useKerberosAuth ? this.getHttpResponseWithKerberosAuth(url) : this.getHttpResponse(url);
        logger.debug("Hadoop job " + this.mrJobId + " status : " + response);
        JsonNode root = new ObjectMapper().readTree(response);
        RMAppState state = RMAppState.valueOf((String)root.findValue("state").textValue());
        FinalApplicationStatus finalStatus = FinalApplicationStatus.valueOf((String)root.findValue("finalStatus").textValue());
        return Pair.of(state, finalStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getHttpResponseWithKerberosAuth(String url) throws IOException {
        String krb5ConfigPath = System.getProperty("java.security.krb5.conf");
        if (krb5ConfigPath == null) {
            krb5ConfigPath = DEFAULT_KRB5_CONFIG_LOCATION;
        }
        boolean skipPortAtKerberosDatabaseLookup = true;
        System.setProperty("java.security.krb5.conf", krb5ConfigPath);
        System.setProperty("sun.security.krb5.debug", "true");
        System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
        DefaultHttpClient client = new DefaultHttpClient();
        AuthSchemeRegistry authSchemeRegistry = new AuthSchemeRegistry();
        authSchemeRegistry.register("negotiate", new SPNegoSchemeFactory(skipPortAtKerberosDatabaseLookup));
        client.setAuthSchemes(authSchemeRegistry);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        Credentials useJaasCreds = new Credentials(){

            @Override
            public String getPassword() {
                return null;
            }

            @Override
            public Principal getUserPrincipal() {
                return null;
            }
        };
        credentialsProvider.setCredentials(new AuthScope(null, -1, null), useJaasCreds);
        client.setCredentialsProvider(credentialsProvider);
        String response = null;
        while (response == null) {
            if (url.startsWith("https://")) {
                HadoopStatusGetter.registerEasyHttps(client);
            }
            if (!url.contains("anonymous=true")) {
                url = url + (url.contains("?") ? "&" : "?");
                url = url + "anonymous=true";
            }
            HttpGet httpget = new HttpGet(url);
            httpget.addHeader("accept", "application/json");
            try {
                CloseableHttpResponse httpResponse = client.execute(httpget);
                String redirect = null;
                Header h = httpResponse.getFirstHeader("Location");
                if (h != null) {
                    redirect = h.getValue();
                    if (!HadoopStatusGetter.isValidURL(redirect)) {
                        logger.info("Get invalid redirect url, skip it: " + redirect);
                        Thread.sleep(1000L);
                        continue;
                    }
                } else {
                    String s;
                    int cut;
                    h = httpResponse.getFirstHeader("Refresh");
                    if (h != null && (cut = (s = h.getValue()).indexOf("url=")) >= 0 && !HadoopStatusGetter.isValidURL(redirect = s.substring(cut + 4))) {
                        logger.info("Get invalid redirect url, skip it: " + redirect);
                        Thread.sleep(1000L);
                        continue;
                    }
                }
                if (redirect == null) {
                    response = IOUtils.toString(httpResponse.getEntity().getContent(), Charset.defaultCharset());
                    logger.debug("Job " + this.mrJobId + " get status check result.\n");
                    continue;
                }
                url = redirect;
                logger.debug("Job " + this.mrJobId + " check redirect url " + url + ".\n");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error(e.getMessage());
            }
            finally {
                httpget.releaseConnection();
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getHttpResponse(String url) throws IOException {
        DefaultHttpClient client = new DefaultHttpClient();
        String response = null;
        while (response == null) {
            if (url.startsWith("https://")) {
                HadoopStatusGetter.registerEasyHttps(client);
            }
            if (!url.contains("anonymous=true")) {
                url = url + (url.contains("?") ? "&" : "?");
                url = url + "anonymous=true";
            }
            HttpGet get = new HttpGet(url);
            get.addHeader("accept", "application/json");
            try {
                HttpResponse res = client.execute(get);
                String redirect = null;
                Header h = res.getFirstHeader("Location");
                if (h != null) {
                    redirect = h.getValue();
                    if (!HadoopStatusGetter.isValidURL(redirect)) {
                        logger.info("Get invalid redirect url, skip it: " + redirect);
                        Thread.sleep(1000L);
                        continue;
                    }
                } else {
                    String s;
                    int cut;
                    h = res.getFirstHeader("Refresh");
                    if (h != null && (cut = (s = h.getValue()).indexOf("url=")) >= 0 && !HadoopStatusGetter.isValidURL(redirect = s.substring(cut + 4))) {
                        logger.info("Get invalid redirect url, skip it: " + redirect);
                        Thread.sleep(1000L);
                        continue;
                    }
                }
                if (redirect == null) {
                    response = res.getStatusLine().toString();
                    logger.debug("Job " + this.mrJobId + " get status check result.\n");
                    continue;
                }
                url = redirect;
                logger.debug("Job " + this.mrJobId + " check redirect url " + url + ".\n");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error(e.getMessage());
            }
            finally {
                get.releaseConnection();
            }
        }
        return response;
    }

    private static void registerEasyHttps(HttpClient client) {
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            try {
                sslContext.init(null, new TrustManager[]{new DefaultX509TrustManager(null){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        logger.debug("getAcceptedIssuers");
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                        logger.debug("checkClientTrusted");
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                        logger.debug("checkServerTrusted");
                    }
                }}, new SecureRandom());
            }
            catch (KeyManagementException keyManagementException) {
                // empty catch block
            }
            SSLSocketFactory ssf = new SSLSocketFactory(sslContext, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            ClientConnectionManager ccm = client.getConnectionManager();
            SchemeRegistry sr = ccm.getSchemeRegistry();
            sr.register(new Scheme("https", 443, ssf));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }

    private static boolean isValidURL(String value) {
        if (StringUtils.isNotEmpty(value)) {
            URL url;
            try {
                url = new URL(value);
            }
            catch (MalformedURLException var5) {
                return false;
            }
            return StringUtils.isNotEmpty(url.getProtocol()) && StringUtils.isNotEmpty(url.getHost());
        }
        return false;
    }
}

