/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark;

import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.CuboidModeEnum;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.JobBuilderSupport;
import org.apache.kylin.engine.mr.steps.CopyDictionaryStep;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.engine.mr.steps.MergeStatisticsWithOldStep;
import org.apache.kylin.engine.mr.steps.UpdateCubeInfoAfterOptimizeStep;
import org.apache.kylin.engine.spark.ISparkOutput;
import org.apache.kylin.engine.spark.SparkCalculateStatsFromBaseCuboidJob;
import org.apache.kylin.engine.spark.SparkCubingByLayerForOpt;
import org.apache.kylin.engine.spark.SparkExecutable;
import org.apache.kylin.engine.spark.SparkExecutableFactory;
import org.apache.kylin.engine.spark.SparkFilterRecommendCuboidDataJob;
import org.apache.kylin.engine.spark.SparkUpdateShardForOldCuboidDataStep;
import org.apache.kylin.engine.spark.SparkUtil;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkBatchOptimizeJobBuilder2
extends JobBuilderSupport {
    private static final Logger logger = LoggerFactory.getLogger(SparkBatchOptimizeJobBuilder2.class);
    private final ISparkOutput.ISparkBatchOptimizeOutputSide outputSide;

    public SparkBatchOptimizeJobBuilder2(CubeSegment optimizeSegment, String submitter) {
        super(optimizeSegment, submitter);
        this.outputSide = SparkUtil.getBatchOptimizeOutputSide2(this.seg);
    }

    public CubingJob build() {
        logger.info("Spark new job to Optimize segment " + this.seg);
        CubingJob result = CubingJob.createOptimizeJob(this.seg, this.submitter, this.config);
        String jobId = result.getId();
        String cuboidRootPath = this.getCuboidRootPath(jobId);
        String optimizeCuboidRootPath = this.getOptimizationCuboidPath(jobId);
        CubeSegment oldSegment = this.seg.getCubeInstance().getOriginalSegmentToOptimize(this.seg);
        Preconditions.checkNotNull(oldSegment, "cannot find the original segment to be optimized by " + this.seg);
        String oldcuboidRootPath = this.getCuboidRootPath(oldSegment) + "*";
        result.addTask(this.createFilterRecommendCuboidDataStep(oldcuboidRootPath, optimizeCuboidRootPath, jobId));
        result.addTask(this.createCopyDictionaryStep());
        String optStatsSourcePath = SparkBatchOptimizeJobBuilder2.getBaseCuboidPath(optimizeCuboidRootPath);
        String optStatsDstPath = this.getOptimizationStatisticsPath(jobId);
        if (this.seg.getConfig().isUseSparkCalculateStatsEnable()) {
            result.addTask(this.createCalculateStatsFromBaseCuboidStepWithSpark(optStatsSourcePath, optStatsDstPath, CuboidModeEnum.RECOMMEND_MISSING, jobId));
        } else {
            result.addTask(this.createCalculateStatsFromBaseCuboid(optStatsSourcePath, optStatsDstPath, CuboidModeEnum.RECOMMEND_MISSING));
        }
        result.addTask(this.createMergeStatisticsWithOldStep(jobId, optStatsDstPath, this.getStatisticsPath(jobId)));
        this.outputSide.addStepPhase2_CreateHTable(result);
        result.addTask(this.createUpdateShardForOldCuboidDataStep(optimizeCuboidRootPath, cuboidRootPath, jobId));
        this.addLayerCubingSteps(result, jobId, CuboidModeEnum.RECOMMEND_MISSING_WITH_BASE, SparkUtil.generateFilePath("base_cuboid", cuboidRootPath), cuboidRootPath);
        this.outputSide.addStepPhase3_BuildCube(result);
        result.addTask(this.createUpdateCubeInfoAfterOptimizeStep(jobId));
        this.outputSide.addStepPhase4_Cleanup(result);
        return result;
    }

    private SparkExecutable createCalculateStatsFromBaseCuboidStepWithSpark(String inputPath, String outputPath, CuboidModeEnum recommendMissing, String jobId) {
        SparkExecutable sparkExecutable = SparkExecutableFactory.instance(this.seg.getConfig());
        sparkExecutable.setName("Calculate Stats From BaseCuboid Step with Spark");
        sparkExecutable.setParam(SparkCalculateStatsFromBaseCuboidJob.OPTION_CUBE_NAME.getOpt(), this.seg.getRealization().getName());
        sparkExecutable.setParam(SparkCalculateStatsFromBaseCuboidJob.OPTION_SEGMENT_ID.getOpt(), this.seg.getUuid());
        sparkExecutable.setParam(SparkCalculateStatsFromBaseCuboidJob.OPTION_INPUT_PATH.getOpt(), inputPath);
        sparkExecutable.setParam(SparkCalculateStatsFromBaseCuboidJob.OPTION_OUTPUT_PATH.getOpt(), outputPath);
        sparkExecutable.setParam(SparkCalculateStatsFromBaseCuboidJob.OPTION_META_URL.getOpt(), this.getSegmentMetadataUrl(this.seg.getConfig(), jobId));
        sparkExecutable.setParam(SparkCalculateStatsFromBaseCuboidJob.OPTION_JOB_MODE.getOpt(), recommendMissing.toString());
        sparkExecutable.setParam(SparkCalculateStatsFromBaseCuboidJob.OPTION_SAMPLING_PERCENT.getOpt(), String.valueOf(this.config.getConfig().getCubingInMemSamplingPercent()));
        sparkExecutable.setJobId(jobId);
        sparkExecutable.setClassName(SparkCalculateStatsFromBaseCuboidJob.class.getName());
        return sparkExecutable;
    }

    private SparkExecutable createFilterRecommendCuboidDataStep(String inputPath, String outputPath, String jobId) {
        SparkExecutable sparkExecutable = SparkExecutableFactory.instance(this.seg.getConfig());
        sparkExecutable.setName("Filter Recommend Cuboid Data for Optimization with Spark");
        sparkExecutable.setParam(SparkFilterRecommendCuboidDataJob.OPTION_CUBE_NAME.getOpt(), this.seg.getRealization().getName());
        sparkExecutable.setParam(SparkFilterRecommendCuboidDataJob.OPTION_SEGMENT_ID.getOpt(), this.seg.getUuid());
        sparkExecutable.setParam(SparkFilterRecommendCuboidDataJob.OPTION_INPUT_PATH.getOpt(), inputPath);
        sparkExecutable.setParam(SparkFilterRecommendCuboidDataJob.OPTION_OUTPUT_PATH.getOpt(), outputPath);
        sparkExecutable.setParam(SparkFilterRecommendCuboidDataJob.OPTION_META_URL.getOpt(), this.getSegmentMetadataUrl(this.seg.getConfig(), jobId));
        sparkExecutable.setClassName(SparkFilterRecommendCuboidDataJob.class.getName());
        sparkExecutable.setJobId(jobId);
        return sparkExecutable;
    }

    private UpdateCubeInfoAfterOptimizeStep createUpdateCubeInfoAfterOptimizeStep(String jobId) {
        UpdateCubeInfoAfterOptimizeStep result = new UpdateCubeInfoAfterOptimizeStep();
        result.setName("Update Cube Info");
        CubingExecutableUtil.setCubeName(this.seg.getRealization().getName(), result.getParams());
        CubingExecutableUtil.setSegmentId(this.seg.getUuid(), result.getParams());
        CubingExecutableUtil.setCubingJobId(jobId, result.getParams());
        return result;
    }

    private void addLayerCubingSteps(CubingJob result, String jobId, CuboidModeEnum mode, String input, String output) {
        SparkExecutable sparkExecutable = SparkExecutableFactory.instance(this.seg.getConfig());
        sparkExecutable.setClassName(SparkCubingByLayerForOpt.class.getName());
        this.configureSparkJob(this.seg, sparkExecutable, jobId, input, output, mode);
        result.addTask(sparkExecutable);
    }

    private SparkExecutable createUpdateShardForOldCuboidDataStep(String inputPath, String outputPath, String jobId) {
        SparkExecutable sparkExecutable = SparkExecutableFactory.instance(this.seg.getConfig());
        sparkExecutable.setName("Update Old Cuboid Shard for Optimization With Spark");
        sparkExecutable.setParam(SparkUpdateShardForOldCuboidDataStep.OPTION_CUBE_NAME.getOpt(), this.seg.getRealization().getName());
        sparkExecutable.setParam(SparkUpdateShardForOldCuboidDataStep.OPTION_SEGMENT_ID.getOpt(), this.seg.getUuid());
        sparkExecutable.setParam(SparkUpdateShardForOldCuboidDataStep.OPTION_INPUT_PATH.getOpt(), inputPath);
        sparkExecutable.setParam(SparkUpdateShardForOldCuboidDataStep.OPTION_OUTPUT_PATH.getOpt(), outputPath);
        sparkExecutable.setParam(SparkUpdateShardForOldCuboidDataStep.OPTION_META_URL.getOpt(), this.getSegmentMetadataUrl(this.seg.getConfig(), jobId));
        sparkExecutable.setJobId(jobId);
        sparkExecutable.setClassName(SparkUpdateShardForOldCuboidDataStep.class.getName());
        return sparkExecutable;
    }

    private MergeStatisticsWithOldStep createMergeStatisticsWithOldStep(String jobId, String optStatsPath, String mergedStatisticsFolder) {
        MergeStatisticsWithOldStep result = new MergeStatisticsWithOldStep();
        result.setName("Merge Cuboid Statistics with Old for Optimization");
        CubingExecutableUtil.setCubingJobId(jobId, result.getParams());
        CubingExecutableUtil.setCubeName(this.seg.getRealization().getName(), result.getParams());
        CubingExecutableUtil.setSegmentId(this.seg.getUuid(), result.getParams());
        CubingExecutableUtil.setStatisticsPath(optStatsPath, result.getParams());
        CubingExecutableUtil.setMergedStatisticsPath(mergedStatisticsFolder, result.getParams());
        return result;
    }

    private AbstractExecutable createCopyDictionaryStep() {
        CopyDictionaryStep result = new CopyDictionaryStep();
        result.setName("Copy dictionary from Old Segment");
        CubingExecutableUtil.setCubeName(this.seg.getRealization().getName(), result.getParams());
        CubingExecutableUtil.setSegmentId(this.seg.getUuid(), result.getParams());
        return result;
    }

    private void configureSparkJob(CubeSegment seg, SparkExecutable sparkExecutable, String jobId, String input, String output, CuboidModeEnum mode) {
        sparkExecutable.setParam(SparkCubingByLayerForOpt.OPTION_CUBE_NAME.getOpt(), seg.getRealization().getName());
        sparkExecutable.setParam(SparkCubingByLayerForOpt.OPTION_SEGMENT_ID.getOpt(), seg.getUuid());
        sparkExecutable.setParam(SparkCubingByLayerForOpt.OPTION_META_URL.getOpt(), this.getSegmentMetadataUrl(seg.getConfig(), jobId));
        sparkExecutable.setParam(SparkCubingByLayerForOpt.OPTION_OUTPUT_PATH.getOpt(), output);
        sparkExecutable.setParam(SparkCubingByLayerForOpt.OPTION_INPUT_PATH.getOpt(), input);
        sparkExecutable.setParam(SparkCubingByLayerForOpt.OPTION_CUBOID_MODE.getOpt(), mode.toString());
        sparkExecutable.setJobId(jobId);
        StringBuilder jars = new StringBuilder();
        StringUtil.appendWithSeparator(jars, seg.getConfig().getSparkAdditionalJars());
        sparkExecutable.setJars(jars.toString());
        sparkExecutable.setName("Optimize Cube with Spark:" + seg.toString());
    }
}

