/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.dim;

import java.util.List;
import java.util.Map;
import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.measure.MeasureIngester;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.measure.MeasureTypeFactory;
import org.apache.kylin.measure.dim.DimCountDistincSerializer;
import org.apache.kylin.measure.dim.DimCountDistinctAggFunc;
import org.apache.kylin.measure.dim.DimCountDistinctAggregator;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.shaded.com.google.common.collect.ImmutableMap;

public class DimCountDistinctMeasureType
extends MeasureType<Object> {
    public static final String DATATYPE_DIM_DC = "dim_dc";
    static final Map<String, Class<?>> UDAF_MAP = ImmutableMap.of("COUNT_DISTINCT", DimCountDistinctAggFunc.class);

    @Override
    public MeasureIngester newIngester() {
        throw new UnsupportedOperationException("No ingester for this measure type.");
    }

    @Override
    public MeasureAggregator newAggregator() {
        return new DimCountDistinctAggregator();
    }

    @Override
    public boolean needRewrite() {
        return true;
    }

    @Override
    public boolean needRewriteField() {
        return false;
    }

    @Override
    public Map<String, Class<?>> getRewriteCalciteAggrFunctions() {
        return UDAF_MAP;
    }

    @Override
    public void adjustSqlDigest(List<MeasureDesc> measureDescs, SQLDigest sqlDigest) {
        for (MeasureDesc measureDesc : measureDescs) {
            sqlDigest.groupbyColumns.addAll(measureDesc.getFunction().getParameter().getColRefs());
            sqlDigest.aggregations.remove(measureDesc.getFunction());
        }
    }

    public static class Factory
    extends MeasureTypeFactory<Object> {
        @Override
        public MeasureType<Object> createMeasureType(String funcName, DataType dataType) {
            return new DimCountDistinctMeasureType();
        }

        @Override
        public String getAggrFunctionName() {
            return "COUNT_DISTINCT";
        }

        @Override
        public String getAggrDataTypeName() {
            return DimCountDistinctMeasureType.DATATYPE_DIM_DC;
        }

        @Override
        public Class getAggrDataTypeSerializer() {
            return DimCountDistincSerializer.class;
        }
    }
}

