/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.jdbc.extensible;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.sql.rowset.CachedRowSet;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.sdk.datasource.framework.JdbcConnector;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.source.ISampleDataDeployer;
import org.apache.kylin.source.ISourceMetadataExplorer;
import org.apache.kylin.source.jdbc.SqlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcExplorer
implements ISourceMetadataExplorer,
ISampleDataDeployer {
    private static final Logger logger = LoggerFactory.getLogger(JdbcExplorer.class);
    private JdbcConnector dataSource;

    public JdbcExplorer(JdbcConnector dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public List<String> listDatabases() throws SQLException {
        return this.dataSource.listDatabases();
    }

    @Override
    public List<String> listTables(String schema) throws SQLException {
        return this.dataSource.listTables(schema);
    }

    @Override
    public Pair<TableDesc, TableExtDesc> loadTableMetadata(String database, String table, String prj) throws SQLException {
        Throwable throwable;
        TableDesc tableDesc;
        block33: {
            tableDesc = new TableDesc();
            tableDesc.setDatabase(database.toUpperCase(Locale.ROOT));
            tableDesc.setName(table.toUpperCase(Locale.ROOT));
            tableDesc.setUuid(UUID.randomUUID().toString());
            tableDesc.setLastModified(0L);
            tableDesc.setProject(prj);
            tableDesc.setSourceType(16);
            throwable = null;
            try (CachedRowSet tables = this.dataSource.getTable(database, table);){
                String tableType = null;
                while (tables.next()) {
                    tableType = tables.getString("TABLE_TYPE");
                }
                if (tableType != null) {
                    tableDesc.setTableType(tableType);
                    break block33;
                }
                throw new RuntimeException(String.format(Locale.ROOT, "table %s not found in schema:%s", table, database));
            }
            catch (Throwable tableType) {
                throwable = tableType;
                throw tableType;
            }
        }
        throwable = null;
        try (CachedRowSet columns = this.dataSource.listColumns(database, table);){
            ArrayList<ColumnDesc> columnDescs = new ArrayList<ColumnDesc>();
            while (columns.next()) {
                int precision;
                String cname = columns.getString("COLUMN_NAME");
                int type = columns.getInt("DATA_TYPE");
                int csize = columns.getInt("COLUMN_SIZE");
                int digits = columns.getInt("DECIMAL_DIGITS");
                int pos = columns.getInt("ORDINAL_POSITION");
                String remarks = columns.getString("REMARKS");
                ColumnDesc cdesc = new ColumnDesc();
                cdesc.setName(cname.toUpperCase(Locale.ROOT));
                String kylinType = this.dataSource.toKylinTypeName(type);
                if ("any".equals(kylinType)) {
                    String typeName = columns.getString("TYPE_NAME");
                    int kylinTypeId = this.dataSource.toKylinTypeId(typeName, type);
                    kylinType = this.dataSource.toKylinTypeName(kylinTypeId);
                }
                int maxPrecision = precision = SqlUtil.isPrecisionApplicable(kylinType) && csize > 0 ? csize : -1;
                if (kylinType.equals("char")) {
                    maxPrecision = KylinConfig.getInstanceFromEnv().getDefaultCharPrecision();
                } else if (kylinType.equals("varchar")) {
                    maxPrecision = KylinConfig.getInstanceFromEnv().getDefaultVarcharPrecision();
                } else if (kylinType.equals("decimal") || kylinType.equals("numeric")) {
                    maxPrecision = KylinConfig.getInstanceFromEnv().getDefaultDecimalPrecision();
                }
                precision = Math.min(precision, maxPrecision);
                int scale = SqlUtil.isScaleApplicable(kylinType) && digits > 0 ? digits : -1;
                cdesc.setDatatype(new DataType(kylinType, precision, scale).toString());
                cdesc.setId(String.valueOf(pos));
                cdesc.setComment(remarks);
                columnDescs.add(cdesc);
            }
            tableDesc.setColumns(columnDescs.toArray(new ColumnDesc[columnDescs.size()]));
            TableExtDesc tableExtDesc = new TableExtDesc();
            tableExtDesc.setIdentity(tableDesc.getIdentity());
            tableExtDesc.setUuid(UUID.randomUUID().toString());
            tableExtDesc.setLastModified(0L);
            tableExtDesc.init(prj);
            Pair<TableDesc, TableExtDesc> pair = Pair.newPair(tableDesc, tableExtDesc);
            return pair;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    @Override
    public void createSampleDatabase(String database) throws Exception {
        String[] sql = this.dataSource.buildSqlToCreateSchema(database);
        this.dataSource.executeUpdate(sql);
    }

    @Override
    public void loadSampleData(String tableName, String tmpDataDir) throws Exception {
        String[] sql = this.dataSource.buildSqlToLoadDataFromLocal(tableName, tmpDataDir);
        this.dataSource.executeUpdate(sql);
    }

    @Override
    public void createSampleTable(TableDesc table) throws Exception {
        LinkedHashMap<String, String> columnInfo = Maps.newLinkedHashMap();
        for (ColumnDesc columnDesc : table.getColumns()) {
            columnInfo.put(columnDesc.getName(), columnDesc.getTypeName());
        }
        String[] sqls = this.dataSource.buildSqlToCreateTable(table.getIdentity(), columnInfo);
        this.dataSource.executeUpdate(sqls);
    }

    @Override
    public void createWrapperView(String origTableName, String viewName) throws Exception {
        String[] sqls = this.dataSource.buildSqlToCreateView(viewName, "SELECT * FROM " + origTableName);
        this.dataSource.executeUpdate(sqls);
    }

    @Override
    public List<String> getRelatedKylinResources(TableDesc table) {
        return Collections.emptyList();
    }

    /*
     * Exception decompiling
     */
    @Override
    public ColumnDesc[] evalQueryMetadata(String query) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void validateSQL(String query) throws Exception {
        this.dataSource.testSql(this.dataSource.convertSql(query));
    }
}

