/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.kafka;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeJoinedFlatTableDesc;
import org.apache.kylin.engine.mr.IInput;
import org.apache.kylin.engine.mr.IMRInput;
import org.apache.kylin.engine.mr.JobBuilderSupport;
import org.apache.kylin.job.JoinedFlatTable;
import org.apache.kylin.job.engine.JobEngineConfig;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.ISegment;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.source.kafka.KafkaInputBase;

public class KafkaMRInput
extends KafkaInputBase
implements IMRInput {
    private CubeSegment cubeSegment;

    @Override
    public IInput.IBatchCubingInputSide getBatchCubingInputSide(IJoinedFlatTableDesc flatDesc) {
        this.cubeSegment = (CubeSegment)flatDesc.getSegment();
        return new KafkaMRBatchCubingInputSide(this.cubeSegment, flatDesc);
    }

    @Override
    public IInput.IBatchMergeInputSide getBatchMergeInputSide(ISegment seg) {
        return new KafkaMRBatchMergeInputSide((CubeSegment)seg);
    }

    @Override
    public IMRInput.IMRTableInputFormat getTableInputFormat(TableDesc table, String uuid) {
        return new KafkaTableInputFormat(this.cubeSegment, null);
    }

    public static class KafkaMRBatchMergeInputSide
    extends KafkaInputBase.BaseBatchMergeInputSide
    implements IMRInput.IMRBatchMergeInputSide {
        KafkaMRBatchMergeInputSide(CubeSegment cubeSegment) {
            super(cubeSegment);
        }
    }

    public static class KafkaMRBatchCubingInputSide
    extends KafkaInputBase.BaseBatchCubingInputSide
    implements IMRInput.IMRBatchCubingInputSide {
        public KafkaMRBatchCubingInputSide(CubeSegment seg, IJoinedFlatTableDesc flatDesc) {
            super(seg, flatDesc);
        }

        @Override
        public IMRInput.IMRTableInputFormat getFlatTableInputFormat() {
            return new KafkaTableInputFormat(this.seg, this.conf);
        }
    }

    public static class KafkaTableInputFormat
    implements IMRInput.IMRTableInputFormat {
        private final CubeSegment cubeSegment;
        private final JobEngineConfig conf;
        private String delimiter = "\u0001";

        public KafkaTableInputFormat(CubeSegment cubeSegment, JobEngineConfig conf) {
            this.cubeSegment = cubeSegment;
            this.conf = conf;
        }

        @Override
        public void configureJob(Job job) {
            job.setInputFormatClass(SequenceFileInputFormat.class);
            String jobId = job.getConfiguration().get("cubingJobId");
            CubeJoinedFlatTableDesc flatHiveTableDesc = new CubeJoinedFlatTableDesc(this.cubeSegment);
            String inputPath = JoinedFlatTable.getTableDir(flatHiveTableDesc, JobBuilderSupport.getJobWorkingDir(this.conf, jobId));
            try {
                FileInputFormat.addInputPath((Job)job, (Path)new Path(inputPath));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public Collection<String[]> parseMapperInput(Object mapperInput) {
            Text text = (Text)mapperInput;
            String[] columns = Bytes.toString(text.getBytes(), 0, text.getLength()).split(this.delimiter, -1);
            return Collections.singletonList(columns);
        }

        @Override
        public String getInputSplitSignature(InputSplit inputSplit) {
            org.apache.hadoop.mapred.FileSplit fs = null;
            if (inputSplit instanceof org.apache.hadoop.mapred.FileSplit) {
                fs = (org.apache.hadoop.mapred.FileSplit)inputSplit;
            } else if (inputSplit instanceof FileSplit) {
                fs = new org.apache.hadoop.mapred.FileSplit((FileSplit)inputSplit);
            } else {
                throw new IllegalArgumentException("Wrong input split: " + inputSplit);
            }
            return fs.getPath().getName() + "_" + fs.getStart() + "_" + fs.getLength();
        }
    }
}

