/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.jackson2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.node.ArrayNode;

class UnmodifiableListDeserializer
extends JsonDeserializer<List> {
    UnmodifiableListDeserializer() {
    }

    @Override
    public List deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        JsonNode node = (JsonNode)mapper.readTree(jp);
        ArrayList<Object> result = new ArrayList<Object>();
        if (node != null) {
            if (node instanceof ArrayNode) {
                ArrayNode arrayNode = (ArrayNode)node;
                for (JsonNode elementNode : arrayNode) {
                    result.add(mapper.readValue(elementNode.traverse(mapper), Object.class));
                }
            } else {
                result.add(mapper.readValue(node.traverse(mapper), Object.class));
            }
        }
        return Collections.unmodifiableList(result);
    }
}

