/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggableCachedThreadPool
extends ThreadPoolExecutor {
    public static final Logger logger = LoggerFactory.getLogger(LoggableCachedThreadPool.class);

    public LoggableCachedThreadPool() {
        super(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        if (t == null && r instanceof Future) {
            try {
                ((Future)((Object)r)).get();
            }
            catch (ExecutionException ee) {
                logger.error("Execution exception when running task in " + Thread.currentThread().getName());
                t = ee.getCause();
            }
            catch (InterruptedException ie) {
                logger.error("Thread interrupted: ");
                Thread.currentThread().interrupt();
            }
            catch (Throwable throwable) {
                t = throwable;
            }
        }
        if (t != null) {
            logger.error("Caught exception in thread " + Thread.currentThread().getName() + ": ", t);
        }
    }
}

