/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.badquery;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.DateFormat;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class BadQueryEntry
extends RootPersistentEntity
implements Comparable<BadQueryEntry> {
    public static final String ADJ_SLOW = "Slow";
    public static final String ADJ_PUSHDOWN = "Pushdown";
    @JsonProperty(value="adj")
    private String adj;
    @JsonProperty(value="sql")
    private String sql;
    @JsonProperty(value="start_time")
    private long startTime;
    @JsonProperty(value="running_seconds")
    private float runningSec;
    @JsonProperty(value="server")
    private String server;
    @JsonProperty(value="thread")
    private String thread;
    @JsonProperty(value="user")
    private String user;
    @JsonProperty(value="query_id")
    private String queryId;
    @JsonProperty(value="cube")
    private String cube;

    public BadQueryEntry(String sql, String adj, long startTime, float runningSec, String server, String thread, String user, String queryId, String cube) {
        this.updateRandomUuid();
        this.adj = adj;
        this.sql = sql;
        this.startTime = startTime;
        this.runningSec = runningSec;
        this.server = server;
        this.thread = thread;
        this.user = user;
        this.queryId = queryId;
        this.cube = cube;
    }

    public BadQueryEntry() {
    }

    public String getQueryId() {
        return this.queryId;
    }

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public float getRunningSec() {
        return this.runningSec;
    }

    public void setRunningSec(float runningSec) {
        this.runningSec = runningSec;
    }

    public String getAdj() {
        return this.adj;
    }

    public void setAdj(String adj) {
        this.adj = adj;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getThread() {
        return this.thread;
    }

    public void setThread(String thread) {
        this.thread = thread;
    }

    public String getCube() {
        return this.cube;
    }

    public void setCube(String cube) {
        this.cube = cube;
    }

    @Override
    public int compareTo(BadQueryEntry obj) {
        int comp = Long.compare(this.startTime, obj.startTime);
        if (comp != 0) {
            return comp;
        }
        return this.sql.compareTo(obj.sql);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.sql, this.startTime);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BadQueryEntry entry = (BadQueryEntry)o;
        if (this.startTime != entry.startTime) {
            return false;
        }
        return this.sql.equals(entry.sql);
    }

    public String toString() {
        return "BadQueryEntry [ adj=" + this.adj + ", server=" + this.server + ", startTime=" + DateFormat.formatToTimeStr(this.startTime) + " ]";
    }
}

