/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.metrics;

import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.metrics.AbstractMetricCollector;
import net.spy.memcached.metrics.MetricCollector;
import org.apache.kylin.job.shaded.com.codahale.metrics.ConsoleReporter;
import org.apache.kylin.job.shaded.com.codahale.metrics.Counter;
import org.apache.kylin.job.shaded.com.codahale.metrics.CsvReporter;
import org.apache.kylin.job.shaded.com.codahale.metrics.Histogram;
import org.apache.kylin.job.shaded.com.codahale.metrics.JmxReporter;
import org.apache.kylin.job.shaded.com.codahale.metrics.Meter;
import org.apache.kylin.job.shaded.com.codahale.metrics.MetricRegistry;
import org.apache.kylin.job.shaded.com.codahale.metrics.Slf4jReporter;
import org.slf4j.LoggerFactory;

public final class DefaultMetricCollector
extends AbstractMetricCollector {
    public static final String DEFAULT_REPORTER_TYPE = "console";
    public static final String DEFAULT_REPORTER_INTERVAL = "30";
    public static final String DEFAULT_REPORTER_OUTDIR = "";
    private MetricRegistry registry = new MetricRegistry();
    private ConcurrentHashMap<String, Counter> counters = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Meter> meters = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Histogram> histograms = new ConcurrentHashMap();

    public DefaultMetricCollector() {
        this.initReporter();
    }

    private void initReporter() {
        String reporterType = System.getProperty("net.spy.metrics.reporter.type", DEFAULT_REPORTER_TYPE);
        String reporterInterval = System.getProperty("net.spy.metrics.reporter.interval", DEFAULT_REPORTER_INTERVAL);
        String reporterDir = System.getProperty("net.spy.metrics.reporter.outdir", DEFAULT_REPORTER_OUTDIR);
        if (reporterType.equals(DEFAULT_REPORTER_TYPE)) {
            ConsoleReporter reporter = ConsoleReporter.forRegistry(this.registry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.SECONDS).build();
            reporter.start(Integer.parseInt(reporterInterval), TimeUnit.SECONDS);
        } else if (reporterType.equals("jmx")) {
            JmxReporter reporter = JmxReporter.forRegistry(this.registry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.SECONDS).build();
            reporter.start();
        } else if (reporterType.equals("csv")) {
            CsvReporter reporter = CsvReporter.forRegistry(this.registry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.SECONDS).build(new File(reporterDir));
            reporter.start(Integer.parseInt(reporterInterval), TimeUnit.SECONDS);
        } else if (reporterType.equals("slf4j")) {
            Slf4jReporter reporter = Slf4jReporter.forRegistry(this.registry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.SECONDS).outputTo(LoggerFactory.getLogger(MetricCollector.class)).build();
            reporter.start(Integer.parseInt(reporterInterval), TimeUnit.SECONDS);
        } else {
            throw new IllegalStateException("Unknown Metrics Reporter Type: " + reporterType);
        }
    }

    @Override
    public void addCounter(String name) {
        if (!this.counters.containsKey(name)) {
            this.counters.put(name, this.registry.counter(name));
        }
    }

    @Override
    public void removeCounter(String name) {
        if (!this.counters.containsKey(name)) {
            this.registry.remove(name);
            this.counters.remove(name);
        }
    }

    @Override
    public void incrementCounter(String name, int amount) {
        if (this.counters.containsKey(name)) {
            this.counters.get(name).inc(amount);
        }
    }

    @Override
    public void decrementCounter(String name, int amount) {
        if (this.counters.containsKey(name)) {
            this.counters.get(name).dec(amount);
        }
    }

    @Override
    public void addMeter(String name) {
        if (!this.meters.containsKey(name)) {
            this.meters.put(name, this.registry.meter(name));
        }
    }

    @Override
    public void removeMeter(String name) {
        if (this.meters.containsKey(name)) {
            this.meters.remove(name);
        }
    }

    @Override
    public void markMeter(String name) {
        if (this.meters.containsKey(name)) {
            this.meters.get(name).mark();
        }
    }

    @Override
    public void addHistogram(String name) {
        if (!this.histograms.containsKey(name)) {
            this.histograms.put(name, this.registry.histogram(name));
        }
    }

    @Override
    public void removeHistogram(String name) {
        if (this.histograms.containsKey(name)) {
            this.histograms.remove(name);
        }
    }

    @Override
    public void updateHistogram(String name, int amount) {
        if (this.histograms.containsKey(name)) {
            this.histograms.get(name).update(amount);
        }
    }
}

