/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.model.validation.rule;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.DimensionDesc;
import org.apache.kylin.cube.model.validation.IValidatorRule;
import org.apache.kylin.cube.model.validation.ResultLevel;
import org.apache.kylin.cube.model.validation.ValidateContext;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.shaded.com.google.common.collect.Lists;

public class FunctionRule
implements IValidatorRule<CubeDesc> {
    @Override
    public void validate(CubeDesc cube, ValidateContext context) {
        List<MeasureDesc> measures = cube.getMeasures();
        if (this.validateMeasureNamesDuplicated(measures, context)) {
            return;
        }
        ArrayList<FunctionDesc> countStarFuncs = new ArrayList<FunctionDesc>();
        for (MeasureDesc measure : measures) {
            FunctionDesc func = measure.getFunction();
            ParameterDesc parameter = func.getParameter();
            if (parameter == null) {
                context.addResult(ResultLevel.ERROR, "Must define parameter for function " + func.getExpression() + " in " + measure.getName());
                return;
            }
            String type = func.getParameter().getType();
            String value = func.getParameter().getValue();
            if (StringUtils.isEmpty((String)type)) {
                context.addResult(ResultLevel.ERROR, "Must define type for parameter type " + func.getExpression() + " in " + measure.getName());
                return;
            }
            if (StringUtils.isEmpty((String)value)) {
                context.addResult(ResultLevel.ERROR, "Must define type for parameter value " + func.getExpression() + " in " + measure.getName());
                return;
            }
            if (StringUtils.isEmpty((String)func.getReturnType())) {
                context.addResult(ResultLevel.ERROR, "Must define return type for function " + func.getExpression() + " in " + measure.getName());
                return;
            }
            if (StringUtils.equalsIgnoreCase((String)"column", (String)type)) {
                this.validateColumnParameter(context, cube, value);
            } else if (StringUtils.equals((String)"constant", (String)type)) {
                this.validateCostantParameter(context, cube, value);
            }
            try {
                func.getMeasureType().validate(func);
            }
            catch (IllegalArgumentException ex) {
                context.addResult(ResultLevel.ERROR, ex.getMessage());
            }
            if (func.isCount() && func.getParameter().isConstant()) {
                countStarFuncs.add(func);
            }
            if (!"TOP_N".equalsIgnoreCase(func.getExpression())) continue;
            if (parameter.getNextParameter() == null) {
                context.addResult(ResultLevel.ERROR, "Must define at least 2 parameters for function " + func.getExpression() + " in " + measure.getName());
                return;
            }
            ArrayList<String> duplicatedCol = Lists.newArrayList();
            for (ParameterDesc groupByCol = parameter.getNextParameter(); groupByCol != null; groupByCol = groupByCol.getNextParameter()) {
                String embeded_groupby = groupByCol.getValue();
                for (DimensionDesc dimensionDesc : cube.getDimensions()) {
                    if (dimensionDesc.getColumn() == null || !dimensionDesc.getColumn().equalsIgnoreCase(embeded_groupby)) continue;
                    duplicatedCol.add(embeded_groupby);
                }
            }
        }
        if (countStarFuncs.size() != 1) {
            context.addResult(ResultLevel.ERROR, "Must define one and only one count(1) function, but there are " + countStarFuncs.size() + " -- " + countStarFuncs);
        }
    }

    private void validateCostantParameter(ValidateContext context, CubeDesc cube, String value) {
        try {
            Integer.parseInt(value);
        }
        catch (Exception e) {
            context.addResult(ResultLevel.ERROR, "Parameter value must be number, but it is " + value);
        }
    }

    private void validateColumnParameter(ValidateContext context, CubeDesc cube, String value) {
        DataModelDesc model = cube.getModel();
        try {
            model.findColumn(value);
        }
        catch (IllegalArgumentException e) {
            context.addResult(ResultLevel.ERROR, e.getMessage());
        }
    }

    private boolean validateMeasureNamesDuplicated(List<MeasureDesc> measures, ValidateContext context) {
        HashSet<String> nameSet = new HashSet<String>();
        for (MeasureDesc measure : measures) {
            if (nameSet.contains(measure.getName())) {
                context.addResult(ResultLevel.ERROR, "There is duplicated measure's name: " + measure.getName());
                return true;
            }
            nameSet.add(measure.getName());
        }
        return false;
    }
}

