/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.streaming;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.AutoReadWriteLock;
import org.apache.kylin.job.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.kylin.metadata.cachesync.Broadcaster;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.cachesync.CaseInsensitiveStringCache;
import org.apache.kylin.metadata.streaming.StreamingConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingManager {
    private static final Logger logger = LoggerFactory.getLogger(StreamingManager.class);
    private KylinConfig config;
    private CaseInsensitiveStringCache<StreamingConfig> streamingMap;
    private CachedCrudAssist<StreamingConfig> crud;
    private AutoReadWriteLock lock = new AutoReadWriteLock();

    public static StreamingManager getInstance(KylinConfig config) {
        return config.getManager(StreamingManager.class);
    }

    static StreamingManager newInstance(KylinConfig config) throws IOException {
        return new StreamingManager(config);
    }

    private StreamingManager(KylinConfig config) throws IOException {
        this.config = config;
        this.streamingMap = new CaseInsensitiveStringCache(config, "streaming");
        this.crud = new CachedCrudAssist<StreamingConfig>(this.getStore(), "/streaming", StreamingConfig.class, this.streamingMap){

            @Override
            protected StreamingConfig initEntityAfterReload(StreamingConfig t, String resourceName) {
                return t;
            }
        };
        this.crud.reloadAll();
        Broadcaster.getInstance(config).registerListener(new StreamingSyncListener(), "streaming");
    }

    private ResourceStore getStore() {
        return ResourceStore.getStore(this.config);
    }

    public StreamingConfig getStreamingConfig(String name) {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForRead();){
            StreamingConfig streamingConfig = (StreamingConfig)this.streamingMap.get(name);
            return streamingConfig;
        }
    }

    public List<StreamingConfig> listAllStreaming() {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForRead();){
            ArrayList<StreamingConfig> arrayList = new ArrayList<StreamingConfig>(this.streamingMap.values());
            return arrayList;
        }
    }

    List<StreamingConfig> reloadAll() throws IOException {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForWrite();){
            this.crud.reloadAll();
            List<StreamingConfig> list = this.listAllStreaming();
            return list;
        }
    }

    public StreamingConfig createStreamingConfig(StreamingConfig streamingConfig) throws IOException {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForWrite();){
            if (streamingConfig == null || StringUtils.isEmpty(streamingConfig.getName())) {
                throw new IllegalArgumentException();
            }
            if (this.streamingMap.containsKey(streamingConfig.resourceName())) {
                throw new IllegalArgumentException("StreamingConfig '" + streamingConfig.getName() + "' already exists");
            }
            streamingConfig.updateRandomUuid();
            StreamingConfig streamingConfig2 = this.crud.save(streamingConfig);
            return streamingConfig2;
        }
    }

    public StreamingConfig updateStreamingConfig(StreamingConfig desc) throws IOException {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForWrite();){
            if (desc.getUuid() == null || desc.getName() == null) {
                throw new IllegalArgumentException("SteamingConfig Illegal.");
            }
            if (!this.streamingMap.containsKey(desc.resourceName())) {
                throw new IllegalArgumentException("StreamingConfig '" + desc.getName() + "' does not exist.");
            }
            StreamingConfig streamingConfig = this.crud.save(desc);
            return streamingConfig;
        }
    }

    public void removeStreamingConfig(StreamingConfig streamingConfig) throws IOException {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForWrite();){
            this.crud.delete(streamingConfig);
        }
    }

    private class StreamingSyncListener
    extends Broadcaster.Listener {
        private StreamingSyncListener() {
        }

        @Override
        public void onEntityChange(Broadcaster broadcaster, String entity, Broadcaster.Event event, String cacheKey) throws IOException {
            String streamingName = cacheKey;
            try (AutoReadWriteLock.AutoLock l = StreamingManager.this.lock.lockForWrite();){
                if (event == Broadcaster.Event.DROP) {
                    StreamingManager.this.streamingMap.removeLocal(streamingName);
                } else {
                    StreamingManager.this.crud.reloadQuietly(streamingName);
                }
            }
        }
    }
}

