/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.sdk.datasource.framework;

import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.sql.rowset.CachedRowSet;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.sdk.datasource.adaptor.AbstractJdbcAdaptor;
import org.apache.kylin.sdk.datasource.framework.conv.ConvMaster;
import org.apache.kylin.sdk.datasource.framework.conv.DefaultConfigurer;
import org.apache.kylin.sdk.datasource.framework.conv.SqlConverter;
import org.apache.kylin.sdk.datasource.framework.def.DataSourceDef;
import org.apache.kylin.sdk.datasource.framework.def.DataSourceDefProvider;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcConnector
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(JdbcConnector.class);
    private final AbstractJdbcAdaptor adaptor;
    private SqlConverter sqlConverter;
    private DataSourceDef jdbcDs;
    private ConvMaster convMaster;

    public JdbcConnector(AbstractJdbcAdaptor adaptor) throws SQLException {
        this.adaptor = adaptor;
        DataSourceDefProvider provider = DataSourceDefProvider.getInstance();
        this.jdbcDs = provider.getById(this.adaptor.getDataSourceId());
        DataSourceDef kylinDs = provider.getDefault();
        this.convMaster = new ConvMaster(kylinDs, this.jdbcDs);
        DefaultConfigurer configurer = new DefaultConfigurer(this.adaptor, this.jdbcDs);
        this.sqlConverter = new SqlConverter(configurer, this.convMaster);
    }

    public String getJdbcUrl() {
        return this.adaptor.getJdbcUrl();
    }

    public String getJdbcDriver() {
        return this.adaptor.getJdbcDriver();
    }

    public String getJdbcUser() {
        return this.adaptor.getJdbcUser();
    }

    public String getJdbcPassword() {
        return this.adaptor.getJdbcPassword();
    }

    public String convertSql(String orig) {
        return this.sqlConverter.convertSql(orig);
    }

    public String convertColumn(String column, String originQuote) {
        return this.sqlConverter.convertColumn(column, originQuote);
    }

    public void testSql(String sql) throws Exception {
        this.adaptor.executeUpdate(sql);
    }

    public int toKylinTypeId(String sourceTypeName, int sourceTypeId) {
        Integer kylinTypeId = this.jdbcDs.getDataTypeValue(sourceTypeName);
        return kylinTypeId != null ? kylinTypeId.intValue() : this.adaptor.toKylinTypeId(sourceTypeName, sourceTypeId);
    }

    public String toKylinTypeName(int sourceTypeId) {
        return this.adaptor.toKylinTypeName(sourceTypeId);
    }

    public void executeUpdate(String sql) throws SQLException {
        this.adaptor.executeUpdate(sql);
    }

    public void executeUpdate(String[] sqls) throws SQLException {
        this.adaptor.executeUpdate(sqls);
    }

    public List<String> listDatabases() throws SQLException {
        List<String> dbNames = this.adaptor.listDatabasesWithCache(true);
        String blackList = this.jdbcDs.getPropertyValue("schema.database.black-list-pattern");
        if (!StringUtils.isEmpty((String)blackList)) {
            String[] patterns = blackList.split(",");
            LinkedList<String> removed = Lists.newLinkedList();
            for (String p : patterns) {
                Pattern ptn = Pattern.compile(p.trim(), 2);
                for (String name : dbNames) {
                    if (!ptn.matcher(name).matches()) continue;
                    removed.add(name);
                }
            }
            dbNames.removeAll(removed);
        }
        return dbNames;
    }

    public List<String> listTables(String schema) throws SQLException {
        return this.adaptor.listTablesWithCache(schema, true);
    }

    public CachedRowSet getTable(String database, String table) throws SQLException {
        return this.adaptor.getTable(database, table);
    }

    public CachedRowSet listColumns(String database, String table) throws SQLException {
        return this.adaptor.getTableColumns(database, table);
    }

    public String[] buildSqlToCreateSchema(String schemaName) {
        return this.adaptor.buildSqlToCreateSchema(schemaName);
    }

    public String[] buildSqlToLoadDataFromLocal(String tableName, String tableFileDir) {
        return this.adaptor.buildSqlToLoadDataFromLocal(tableName, tableFileDir);
    }

    public String[] buildSqlToCreateTable(String identity, LinkedHashMap<String, String> columnInfo) {
        return this.adaptor.buildSqlToCreateTable(identity, columnInfo);
    }

    public String[] buildSqlToCreateView(String viewName, String s) {
        return this.adaptor.buildSqlToCreateView(viewName, s);
    }

    public Connection getConnection() throws SQLException {
        return this.adaptor.getConnection();
    }

    public String getPropertyValue(String key, String defaultValue) {
        return this.jdbcDs.getPropertyValue(key, defaultValue);
    }

    public String getPropertyValue(String key) {
        return this.jdbcDs.getPropertyValue(key);
    }

    public SqlConverter getSqlConverter() {
        return this.sqlConverter;
    }

    @Override
    public void close() throws IOException {
        if (this.adaptor != null) {
            this.adaptor.close();
        }
    }
}

