/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.remote;

import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Objects;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.ConnectionConfig;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.remote.AuthenticationType;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.remote.AvaticaCommonsHttpClientImpl;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.remote.AvaticaCommonsHttpClientSpnegoImpl;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.remote.AvaticaHttpClient;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.remote.AvaticaHttpClientFactory;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.remote.DoAsAvaticaHttpClient;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.remote.HostnameVerificationConfigurable;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.remote.KerberosConnection;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.remote.KeyStoreConfigurable;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.remote.TrustStoreConfigurable;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.remote.UsernamePasswordAuthenticateable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvaticaHttpClientFactoryImpl
implements AvaticaHttpClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AvaticaHttpClientFactoryImpl.class);
    public static final String HTTP_CLIENT_IMPL_DEFAULT = AvaticaCommonsHttpClientImpl.class.getName();
    public static final String SPNEGO_HTTP_CLIENT_IMPL_DEFAULT = AvaticaCommonsHttpClientSpnegoImpl.class.getName();
    public static final AvaticaHttpClientFactoryImpl INSTANCE = new AvaticaHttpClientFactoryImpl();

    public static AvaticaHttpClientFactoryImpl getInstance() {
        return INSTANCE;
    }

    @Override
    public AvaticaHttpClient getClient(URL url, ConnectionConfig config, KerberosConnection kerberosUtil) {
        String className = config.httpClientClass();
        if (null == className) {
            className = "SPNEGO".equalsIgnoreCase(config.authentication()) ? SPNEGO_HTTP_CLIENT_IMPL_DEFAULT : HTTP_CLIENT_IMPL_DEFAULT;
        }
        AvaticaHttpClient client = this.instantiateClient(className, url);
        if (null != kerberosUtil) {
            client = new DoAsAvaticaHttpClient(client, kerberosUtil);
        }
        if (client instanceof TrustStoreConfigurable) {
            File truststore = config.truststore();
            String truststorePassword = config.truststorePassword();
            if (null != truststore && null != truststorePassword) {
                ((TrustStoreConfigurable)((Object)client)).setTrustStore(truststore, truststorePassword);
            }
        } else {
            LOG.debug("{} is not capable of SSL/TLS communication", (Object)client.getClass().getName());
        }
        if (client instanceof KeyStoreConfigurable) {
            File keystore = config.keystore();
            String keystorePassword = config.keystorePassword();
            String keyPassword = config.keyPassword();
            if (null != keystore && null != keystorePassword && null != keyPassword) {
                ((KeyStoreConfigurable)((Object)client)).setKeyStore(keystore, keystorePassword, keyPassword);
            }
        } else {
            LOG.debug("{} is not capable of Mutual authentication", (Object)client.getClass().getName());
        }
        if (client instanceof HostnameVerificationConfigurable) {
            ((HostnameVerificationConfigurable)((Object)client)).setHostnameVerification(config.hostnameVerification());
        } else {
            LOG.debug("{} is not capable of configurable SSL/TLS hostname verification", (Object)client.getClass().getName());
        }
        if (client instanceof UsernamePasswordAuthenticateable) {
            String authString = config.authentication();
            if (null == authString) {
                return client;
            }
            AuthenticationType authType = AuthenticationType.valueOf(authString);
            String username = config.avaticaUser();
            String password = config.avaticaPassword();
            if (this.isUserPasswordAuth(authType)) {
                if (null != username && null != password) {
                    ((UsernamePasswordAuthenticateable)((Object)client)).setUsernamePassword(authType, username, password);
                } else {
                    LOG.debug("Username or password was null");
                }
            } else {
                LOG.debug("{} is not capable of username/password authentication.", (Object)authType);
            }
        }
        return client;
    }

    private AvaticaHttpClient instantiateClient(String className, URL url) {
        try {
            Class<?> clz = Class.forName(className);
            Constructor<?> constructor = clz.getConstructor(URL.class);
            Object instance = constructor.newInstance(Objects.requireNonNull(url));
            return (AvaticaHttpClient)AvaticaHttpClient.class.cast(instance);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to construct AvaticaHttpClient implementation " + className, e);
        }
    }

    private boolean isUserPasswordAuth(AuthenticationType authType) {
        return AuthenticationType.BASIC == authType || AuthenticationType.DIGEST == authType;
    }
}

