/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cache.cachemanager;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Status;
import org.apache.kylin.cache.ehcache.InstrumentedEhCacheCache;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.springframework.cache.Cache;
import org.springframework.cache.ehcache.EhCacheCache;
import org.springframework.cache.support.AbstractCacheManager;
import org.springframework.util.Assert;

public class InstrumentedEhCacheCacheManager
extends AbstractCacheManager {
    private CacheManager cacheManager;
    private Map<String, String> metricsConfig = KylinConfig.getInstanceFromEnv().getKylinMetricsConf();
    private boolean enableMetrics = false;

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        if ("true".equalsIgnoreCase(this.metricsConfig.get("ehcache.enabled"))) {
            this.enableMetrics = true;
        }
    }

    protected Collection<Cache> loadCaches() {
        Assert.notNull((Object)this.cacheManager, "A backing EhCache CacheManager is required");
        Status status = this.cacheManager.getStatus();
        Assert.isTrue(Status.STATUS_ALIVE.equals(status), "An 'alive' EhCache CacheManager is required - current cache is " + status.toString());
        String[] names = this.cacheManager.getCacheNames();
        LinkedHashSet<Cache> caches = Sets.newLinkedHashSetWithExpectedSize(names.length);
        for (String name : names) {
            if (this.enableMetrics) {
                caches.add(new InstrumentedEhCacheCache(this.cacheManager.getEhcache(name)));
                continue;
            }
            caches.add((Cache)new EhCacheCache(this.cacheManager.getEhcache(name)));
        }
        return caches;
    }

    public Cache getCache(String name) {
        Ehcache ehcache;
        Cache cache = super.getCache(name);
        if (cache == null && (ehcache = this.cacheManager.getEhcache(name)) != null) {
            cache = this.enableMetrics ? new InstrumentedEhCacheCache(ehcache) : new EhCacheCache(ehcache);
            this.addCache(cache);
        }
        return cache;
    }
}

