/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.persistence.ContentWriter;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.WriteConflictException;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.tool.shaded.org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDFSResourceStore
extends ResourceStore {
    private static final Logger logger = LoggerFactory.getLogger(HDFSResourceStore.class);
    private Path hdfsMetaPath;
    private FileSystem fs;
    public static final String HDFS_SCHEME = "hdfs";

    public HDFSResourceStore(KylinConfig kylinConfig) throws Exception {
        this(kylinConfig, kylinConfig.getMetadataUrl());
    }

    public HDFSResourceStore(KylinConfig kylinConfig, StorageURL metadataUrl) throws Exception {
        super(kylinConfig);
        Preconditions.checkState(HDFS_SCHEME.equals(metadataUrl.getScheme()));
        String path = metadataUrl.getParameter("path");
        if (path == null) {
            path = kylinConfig.getHdfsWorkingDirectory(null) + "tmp_metadata";
            logger.warn("Missing path, fall back to {}. ", (Object)path);
        }
        this.fs = HadoopUtil.getFileSystem(path);
        Path metadataPath = new Path(path);
        if (!this.fs.exists(metadataPath)) {
            logger.warn("Path not exist in HDFS, create it: {}. ", (Object)path);
            this.createMetaFolder(metadataPath);
        }
        this.hdfsMetaPath = metadataPath;
        logger.info("hdfs meta path : {}", (Object)this.hdfsMetaPath);
    }

    private void createMetaFolder(Path metaDirName) throws Exception {
        if (!this.fs.exists(metaDirName)) {
            this.fs.mkdirs(metaDirName);
        }
        logger.info("hdfs meta path created: {}", (Object)metaDirName);
    }

    @Override
    protected NavigableSet<String> listResourcesImpl(String folderPath) throws IOException {
        return this.listResourcesImpl(folderPath, false);
    }

    @Override
    protected NavigableSet<String> listResourcesRecursivelyImpl(String folderPath) throws IOException {
        return this.listResourcesImpl(folderPath, true);
    }

    private NavigableSet<String> listResourcesImpl(String folderPath, boolean recursive) throws IOException {
        String prefix;
        Path p = this.getRealHDFSPath(folderPath);
        String string = prefix = folderPath.endsWith("/") ? folderPath : folderPath + "/";
        if (!this.fs.exists(p) || !this.fs.isDirectory(p)) {
            return null;
        }
        TreeSet<String> r = recursive ? this.getAllFilePath(p, prefix) : this.getFilePath(p, prefix);
        return r.isEmpty() ? null : r;
    }

    private TreeSet<String> getFilePath(Path p, String resPathPrefix) throws IOException {
        TreeSet<String> fileList = new TreeSet<String>();
        for (FileStatus fileStat : this.fs.listStatus(p)) {
            fileList.add(resPathPrefix + fileStat.getPath().getName());
        }
        return fileList;
    }

    TreeSet<String> getAllFilePath(Path filePath, String resPathPrefix) throws IOException {
        String fsPathPrefix = filePath.toUri().getPath();
        TreeSet<String> fileList = new TreeSet<String>();
        RemoteIterator it = this.fs.listFiles(filePath, true);
        while (it.hasNext()) {
            String path = ((LocatedFileStatus)it.next()).getPath().toUri().getPath();
            if (!path.startsWith(fsPathPrefix)) {
                throw new IllegalStateException("File path " + path + " is supposed to start with " + fsPathPrefix);
            }
            String resPath = resPathPrefix + path.substring(fsPathPrefix.length() + 1);
            fileList.add(resPath);
        }
        return fileList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void visitFolderImpl(String folderPath, boolean recursive, ResourceStore.VisitFilter filter, boolean loadContent, ResourceStore.Visitor visitor) throws IOException {
        Path p = this.getRealHDFSPath(folderPath);
        if (!this.fs.exists(p) || !this.fs.isDirectory(p)) {
            return;
        }
        String fsPathPrefix = p.toUri().getPath();
        String resPathPrefix = folderPath.endsWith("/") ? folderPath : folderPath + "/";
        RemoteIterator it = this.fs.listFiles(p, recursive);
        while (it.hasNext()) {
            LocatedFileStatus status = (LocatedFileStatus)it.next();
            if (status.isDirectory()) continue;
            String path = status.getPath().toUri().getPath();
            if (!path.startsWith(fsPathPrefix)) {
                throw new IllegalStateException("File path " + path + " is supposed to start with " + fsPathPrefix);
            }
            String resPath = resPathPrefix + path.substring(fsPathPrefix.length() + 1);
            if (!filter.matches(resPath, status.getModificationTime())) continue;
            try (RawResource raw = loadContent ? new RawResource(resPath, status.getModificationTime(), (InputStream)this.fs.open(status.getPath())) : new RawResource(resPath, status.getModificationTime());){
                visitor.visit(raw);
            }
        }
    }

    @Override
    protected boolean existsImpl(String resPath) throws IOException {
        Path p = this.getRealHDFSPath(resPath);
        return this.fs.exists(p) && this.fs.isFile(p);
    }

    @Override
    protected RawResource getResourceImpl(String resPath) throws IOException {
        Path p = this.getRealHDFSPath(resPath);
        if (this.fs.exists(p) && this.fs.isFile(p)) {
            FileStatus fileStatus = this.fs.getFileStatus(p);
            if (fileStatus.getLen() == 0L) {
                logger.warn("Zero length file: {}. ", (Object)p);
            }
            FSDataInputStream in = this.fs.open(p);
            long ts = fileStatus.getModificationTime();
            return new RawResource(resPath, ts, (InputStream)in);
        }
        return null;
    }

    @Override
    protected long getResourceTimestampImpl(String resPath) throws IOException {
        Path p = this.getRealHDFSPath(resPath);
        if (!this.fs.exists(p) || !this.fs.isFile(p)) {
            return 0L;
        }
        try {
            return this.fs.getFileStatus(p).getModificationTime();
        }
        catch (Exception e) {
            throw new IOException("Put resource fail", e);
        }
    }

    @Override
    protected void putResourceImpl(String resPath, ContentWriter content, long ts) throws IOException {
        logger.trace("res path : {}. ", (Object)resPath);
        Path p = this.getRealHDFSPath(resPath);
        logger.trace("put resource : {}. ", (Object)p.toUri());
        FSDataOutputStream out = null;
        try {
            out = this.fs.create(p, true);
            content.write((DataOutputStream)out);
        }
        catch (Exception e) {
            try {
                throw new IOException("Put resource fail", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                this.fs.setTimes(p, ts, -1L);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        this.fs.setTimes(p, ts, -1L);
    }

    @Override
    protected long checkAndPutResourceImpl(String resPath, byte[] content, long oldTS, long newTS) throws IOException, WriteConflictException {
        Path p = this.getRealHDFSPath(resPath);
        if (!this.fs.exists(p)) {
            if (oldTS != 0L) {
                throw new IllegalStateException("For not exist file. OldTS have to be 0. but Actual oldTS is : " + oldTS);
            }
        } else {
            long realLastModify = this.getResourceTimestamp(resPath);
            if (realLastModify != oldTS) {
                throw new WriteConflictException("Overwriting conflict " + resPath + ", expect old TS " + oldTS + ", but found " + realLastModify);
            }
        }
        this.putResourceImpl(resPath, ContentWriter.create(content), newTS);
        return newTS;
    }

    @Override
    protected void updateTimestampImpl(String resPath, long timestamp) throws IOException {
        try {
            Path p = this.getRealHDFSPath(resPath);
            if (this.fs.exists(p)) {
                this.fs.setTimes(p, timestamp, -1L);
            }
        }
        catch (Exception e) {
            throw new IOException("Update resource timestamp fail", e);
        }
    }

    @Override
    protected void deleteResourceImpl(String resPath) throws IOException {
        try {
            Path p = this.getRealHDFSPath(resPath);
            if (this.fs.exists(p)) {
                this.fs.delete(p, true);
            }
        }
        catch (Exception e) {
            throw new IOException("Delete resource fail", e);
        }
    }

    @Override
    protected void deleteResourceImpl(String resPath, long timestamp) throws IOException {
        block3: {
            try {
                Path p = this.getRealHDFSPath(resPath);
                if (!this.fs.exists(p)) break block3;
                long origLastModified = this.fs.getFileStatus(p).getModificationTime();
                if (this.checkTimeStampBeforeDelete(origLastModified, timestamp)) {
                    this.fs.delete(p, true);
                    break block3;
                }
                throw new IOException("Resource " + resPath + " timestamp not match, [originLastModified: " + origLastModified + ", timestampToDelete: " + timestamp + "]");
            }
            catch (Exception e) {
                throw new IOException("Delete resource fail", e);
            }
        }
    }

    @Override
    protected String getReadableResourcePathImpl(String resPath) {
        return this.getRealHDFSPath(resPath).toString();
    }

    private Path getRealHDFSPath(String resourcePath) {
        if (resourcePath.equals("/")) {
            return this.hdfsMetaPath;
        }
        if (resourcePath.startsWith("/") && resourcePath.length() > 1) {
            resourcePath = resourcePath.substring(1, resourcePath.length());
        }
        return new Path(this.hdfsMetaPath, resourcePath);
    }
}

