/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.tool.shaded.org.apache.commons.lang3.StringUtils;

public abstract class AbstractApplication {
    protected abstract Options getOptions();

    protected abstract void execute(OptionsHelper var1) throws Exception;

    public final void execute(String[] args) {
        OptionsHelper optionsHelper = new OptionsHelper();
        System.out.println("Running " + this.getClass().getName() + " " + StringUtils.join((Object[])args, " "));
        try {
            optionsHelper.parseOptions(this.getOptions(), args);
            if (optionsHelper.isHelpOption()) {
                optionsHelper.printUsage(this.getClass().getName(), this.getOptions());
                return;
            }
            this.execute(optionsHelper);
        }
        catch (ParseException e) {
            optionsHelper.printUsage(this.getClass().getName(), this.getOptions());
            throw new RuntimeException("error parsing args", e);
        }
        catch (Exception e) {
            throw new RuntimeException("error execute " + this.getClass().getName() + ". Root cause: " + e.getMessage(), e);
        }
    }
}

