/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.model.AggregationGroup;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.collect.Lists;

public abstract class CuboidScheduler {
    protected final CubeDesc cubeDesc;
    private transient List<List<Long>> cuboidsByLayer;

    public static CuboidScheduler getInstance(CubeDesc cubeDesc) {
        String clzName = cubeDesc.getConfig().getCuboidScheduler();
        try {
            Class<CuboidScheduler> clz = ClassUtil.forName(clzName, CuboidScheduler.class);
            return clz.getConstructor(CubeDesc.class).newInstance(cubeDesc);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected CuboidScheduler(CubeDesc cubeDesc) {
        this.cubeDesc = cubeDesc;
    }

    public abstract Set<Long> getAllCuboidIds();

    public abstract int getCuboidCount();

    public abstract List<Long> getSpanningCuboid(long var1);

    public abstract long findBestMatchCuboid(long var1);

    public abstract Set<Long> calculateCuboidsForAggGroup(AggregationGroup var1);

    public long getBaseCuboidId() {
        return Cuboid.getBaseCuboidId(this.cubeDesc);
    }

    public CubeDesc getCubeDesc() {
        return this.cubeDesc;
    }

    public boolean isValid(long requestCuboid) {
        return this.getAllCuboidIds().contains(requestCuboid);
    }

    public List<List<Long>> getCuboidsByLayer() {
        int size;
        if (this.cuboidsByLayer != null) {
            return this.cuboidsByLayer;
        }
        int totalNum = 0;
        this.cuboidsByLayer = Lists.newArrayList();
        this.cuboidsByLayer.add(Collections.singletonList(Cuboid.getBaseCuboidId(this.cubeDesc)));
        ++totalNum;
        List<Long> lastLayer = this.cuboidsByLayer.get(this.cuboidsByLayer.size() - 1);
        while (!lastLayer.isEmpty()) {
            ArrayList<Long> newLayer = Lists.newArrayList();
            for (Long parent : lastLayer) {
                newLayer.addAll(this.getSpanningCuboid(parent));
            }
            if (newLayer.isEmpty()) break;
            this.cuboidsByLayer.add(newLayer);
            totalNum += newLayer.size();
            lastLayer = newLayer;
        }
        Preconditions.checkState(totalNum == (size = this.getAllCuboidIds().size()), "total Num: " + totalNum + " actual size: " + size);
        return this.cuboidsByLayer;
    }

    public int getBuildLevel() {
        return this.getCuboidsByLayer().size() - 1;
    }

    public String getCuboidCacheKey() {
        return this.cubeDesc.getName();
    }
}

